package org.simantics.modeling.adapters;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;

public class SCLLabelRule implements LabelRule {

    private Resource rule;
    
    public SCLLabelRule(ReadGraph graph, Resource rule) {
        this.rule = rule;
    }
    
    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class) || contentType.equals(Variable.class);
    }

    @Override
    public Map<String, String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance(graph);
        
        Variable ruleVariable = Variables.getVariable(graph, rule);

        Function1<Object,List<String>> getLabels = ruleVariable.getPossiblePropertyValue(graph, MOD.SCLLabelRule_getLabels);
        if(getLabels == null) return Collections.emptyMap();

        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get("graph");
        try {
            sclContext.put("graph", graph);
            List<String> value = getLabels.apply(content);
            Map<String,String> result = new HashMap<>();
            for(int i=0;i<value.size();i+=2) {
            	result.put(value.get(i), value.get(i+1));
            }
            return result;
        } catch (Throwable t) {
        	throw new DatabaseException(t);
        } finally {
            sclContext.put("graph", oldGraph);
        }
    }

}
