/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.adapters;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.primitiverequest.PossibleRelatedValue;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.layer0.Layer0;

public class ExportModelActionFactory implements ActionFactory {

    String format;
    String extension;
    
    public ExportModelActionFactory(String extension, String format) {
        this.extension = extension;
        this.format = format;
    }

    @Override
    public Runnable create(Object target_) {
        final Resource target = (Resource)target_;
        return new Runnable() {
            @Override
            public void run() {

            	Shell shell = Display.getDefault().getActiveShell();
 
            	Session session = Simantics.getSession();

            	try {

            		final Layer0 L0 = Layer0.getInstance(session);

            		final String name = session.syncRequest(new PossibleRelatedValue<String>(target, L0.HasName, Bindings.STRING));

            		FileDialog dialog = new FileDialog(shell, SWT.SAVE);
            		dialog.setFilterExtensions(new String[] { "*." + extension });
            		dialog.setFileName(name + "." + extension);
            		String newFileName = dialog.open();
            		if(newFileName == null) return;

            		if(!newFileName.endsWith(extension))
            			newFileName += "." + extension;

            		try (TransferableGraphSource s = session.sync(new ModelTransferableGraphSourceRequest(createConf(session, target)))) {
            		    TransferableGraphs.writeTransferableGraph(session, format, 1, s, new File(newFileName));
            		}
        	
        		} catch (Exception e) {
        			Logger.defaultLogError(e);
        		}

            }
        };
    }

    private TransferableGraphConfiguration2 createConf(Session session, final Resource model) throws DatabaseException {
        return session.sync(new UniqueRead<TransferableGraphConfiguration2>() {
            @Override
            public TransferableGraphConfiguration2 perform(ReadGraph graph) throws DatabaseException {
                return new TransferableGraphConfiguration2(graph, model, true, false);
            }
        });
    }

}
