package org.simantics.modeling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.diagram.elements.TextGridNode;
import org.simantics.diagram.elements.TextNode;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.scenegraph.ICanvasSceneGraphProvider;
import org.simantics.g2d.utils.CanvasUtils;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.BackgroundNode;
import org.simantics.scenegraph.g2d.nodes.BoundsNode;
import org.simantics.scenegraph.g2d.nodes.ConnectionNode;
import org.simantics.scenegraph.g2d.nodes.DataNode;
import org.simantics.scenegraph.g2d.nodes.DecorationSVGNode;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.trend.impl.ItemNode;
import org.simantics.utils.threads.ThreadUtils;

public class SCLScenegraph {
	
	public static ICanvasSceneGraphProvider getICanvasSceneGraphProvider(Resource model, Resource diagram, String diagramRVI) throws DatabaseException, InterruptedException {
		ICanvasSceneGraphProvider provider = DiagramNodeUtil.loadSceneGraphProvider(model, diagram, diagramRVI);
		return provider;
	}
	
	public static void disposeSceneGraphProvider(ICanvasSceneGraphProvider provider) {
		provider.dispose();
	}
	
	//public static Resource getDiagramRuntime(Resource ) 
	
	
//	public static String getNodeTransform(ICanvasContext ctx, String name) throws DatabaseException, InterruptedException {
//		return getNodeTransform(ctx, name);
//	}
	
	public static String getNodeTransform(ICanvasContext ctx, String name) {
		
		Set<TextNode> texts = NodeUtil.collectNodes(ctx.getSceneGraph(), TextNode.class);
		for (TextNode text : texts) {
			String nodeName = NodeUtil.getNodeName(text);
			if (nodeName.equals(name)) {
				String transform = text.getTransform().toString();
				return transform;
			}
		}
		return "No node found";
	}
	
	public static String getNodeText(ICanvasContext ctx, String name) {
		
		Set<TextNode> texts = NodeUtil.collectNodes(ctx.getSceneGraph(), TextNode.class);
		for (TextNode text : texts) {
			String nodeName = NodeUtil.getNodeName(text);
			if (nodeName.equals(name)) {
				String texti = text.getText();
				return texti;
			}
		}
		return "No node found";
	}
	
	public static String getNodeCount(ICanvasContext ctx) {
		G2DSceneGraph g2 = ctx.getSceneGraph();
		int amount = NodeUtil.countTreeNodes(g2);
		return "Node count: " + amount;
	}
	
    public static String getAllNodes (ICanvasContext ctx) {
    	
    	Set<G2DSceneGraph> g2 = NodeUtil.collectNodes(ctx.getSceneGraph(), G2DSceneGraph.class);
    	int amount = g2.size() +1;
    	return "All nodes: " + amount;
    }
    
    public static String getBoundsNodes (ICanvasContext ctx) {
    	
    	Set<BoundsNode> bn = NodeUtil.collectNodes(ctx.getSceneGraph(), BoundsNode.class);
    	int amount = bn.size();
    	return "BoundsNodes: " + amount;
    }
    
    public static String getBackgroundNodes (ICanvasContext ctx) {
    	
    	Set<BackgroundNode> bg = NodeUtil.collectNodes(ctx.getSceneGraph(), BackgroundNode.class);
    	int amount = bg.size();
    	return "BackgroundNodes: " + amount;
    }
    
    public static String getDataNodes (ICanvasContext ctx) {
    	
    	Set<DataNode> dn = NodeUtil.collectNodes(ctx.getSceneGraph(), DataNode.class);
    	int amount = dn.size();
    	return "DataNodes: " + amount;
    }
    
    public static String getNavigationNodes (ICanvasContext ctx) {
    	
    	Set<NavigationNode> g2 = NodeUtil.collectNodes(ctx.getSceneGraph(), NavigationNode.class);
    	int amount = g2.size();
    	return "NavigationNodes: " + amount;
    }
    
    public static String getParentNodes (ICanvasContext ctx) {
    	
    	Set<G2DParentNode> g2 = NodeUtil.collectNodes(ctx.getSceneGraph(), G2DParentNode.class);
    	int amount = g2.size();
    	return "ParentNodes: " + amount;
    }
    
    public static String getDecorationNodes (ICanvasContext ctx) {
    	
    	Set<DecorationSVGNode> deco = NodeUtil.collectNodes(ctx.getSceneGraph(), DecorationSVGNode.class);
    	int amount = deco.size();
    	return "DecorationNodes: " + amount;
    }
    
    public static String getSingleElementNodes (ICanvasContext ctx) {
    	
    	Set<SingleElementNode> g2 = NodeUtil.collectNodes(ctx.getSceneGraph(), SingleElementNode.class);
    	int amount = g2.size();
    	return "SingleElementNodes: " + amount;
    }
    
    public static String getConnectionNodes (ICanvasContext ctx) {
    	
    	Set<ConnectionNode> g2 = NodeUtil.collectNodes(ctx.getSceneGraph(), ConnectionNode.class);
    	int amount = g2.size();
    	return "ConnectionNodes: " + amount;
    }
    
    public static String getTextNodes (ICanvasContext ctx) {
    	
    	Set<TextNode> tn = NodeUtil.collectNodes(ctx.getSceneGraph(), TextNode.class);
    	Set<TextGridNode> tgn = NodeUtil.collectNodes(ctx.getSceneGraph(), TextGridNode.class);
    	int amount = tn.size() + tgn.size();
    	return "TextNodes: " + amount;
    }
    
    public static String getItemNodes (ICanvasContext ctx) {
    	
    	Set<ItemNode> item = NodeUtil.collectNodes(ctx.getSceneGraph(), ItemNode.class);
    	int amount = item.size();
    	return "ItemNodes: " + amount;
    }
  
    public static String editNodeText (ICanvasContext ctx, String module, String previous_value, String new_value) {
    	    	
    	Set<TextNode> textGridNodes = NodeUtil.collectNodes(ctx.getSceneGraph(), TextNode.class);
    	for (TextNode modulenode : textGridNodes) {
    		if (module.equals(modulenode.getText())) {
    			//System.out.println("Module what we were looking for: " + module);
    			//System.out.println("Modulenode: " + modulenode.getText());
    			
    			ParentNode<?> parentnode = modulenode.getParent();
    			//System.out.println("Parentnode: " + parentnode);
    			
    			Collection<TextNode> textnodes = (Collection<TextNode>) parentnode.getNodes();
    			for (TextNode valuenode : textnodes) {
	    			if (previous_value.equals(valuenode.getText())) {
	        			//System.out.println("Value what we were looking for: " + previous_value);
	        			//System.out.println("Valuenode: " + valuenode.getText());
	        			
	        			//valuenode.setEditMode(true);
	        			valuenode.activateEdit(0, null, ctx);
	        			valuenode.setText(new_value);
	        			valuenode.fireTextEditingEnded();
	        			
	        			//System.out.println("valuenode modified: " + valuenode);
	        			return "Modified module " + module + " with value " + new_value;
	    			}
    			}
    			return "Not found module : " + module;
    		}
    	}
        return "No nodes in scenegraph!";
    }

    public static String sceneGraphTest (ICanvasContext ctx, String module, String value) {
    	
    	boolean module_founded = false;
    	boolean value_founded = false;
    	
    	Set<G2DSceneGraph> g2 = NodeUtil.collectNodes(ctx.getSceneGraph(), G2DSceneGraph.class);
    	System.out.println("Total amount of nodes: " + g2.size() + 1);
    	
    	Set<TextGridNode> grid = NodeUtil.collectNodes(ctx.getSceneGraph(), TextGridNode.class);
    	Integer textGridNodeAmount = grid.size();
    	System.out.println("Amount of TextGridNodes " + textGridNodeAmount);
    	
    	Set<TextNode> texts = NodeUtil.collectNodes(ctx.getSceneGraph(), TextNode.class);
    	Integer textNodeAmount = grid.size();
    	System.out.println("Amount of TextNodes " + textNodeAmount);

        for (TextNode node : texts) {
            if (module.equals(node.getText())) {
            	module_founded = true;
            	System.out.println("Correct module " + module + " founded.");
            }
            if (value.equals(node.getText())) {
            	value_founded = true;
            	System.out.println("Correct value " + value + " founded.");
            }
        }
        
        if (value_founded == true && module_founded == true) {
        	return "Found both correct module " + module + " and value " + value;
        }
        if (value_founded == false && module_founded == true) {
        	return "Found only correct module " + module + " but not value " + value;
        }
        if (value_founded == true && module_founded == false) {
        	return "Found only correct value " + value + " but not module " + module;
        }
        else {
        	return "Didn't found either module " + module + " or value " + value;
        }
    }
    
     public static boolean copyPaste (final ICanvasContext source_ctx, final ICanvasContext target_ctx, List<Resource> modules) throws DatabaseException {
    	
    	IDiagram idiagram = source_ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);

		DataElementMap dem = idiagram.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class);
		if (dem != null) {
			final Collection<IElement> newSelection = new ArrayList<IElement>();
			for (Resource module : modules) {
				IElement element = dem.getElement(idiagram, module);
				if (element != null) {
					newSelection.add(element);
				} else {
					throw new DatabaseException("Could not find IElement for " + element);
				}
			}
			
			ThreadUtils.syncExec(source_ctx.getThreadAccess(), new Runnable() {
	            @Override
	            public void run() {
	                if (source_ctx.isDisposed())
	                    return;
	                Selection selection = source_ctx.getAtMostOneItemOfClass(Selection.class);
	                if (selection != null) {
	                    // This prevents workbench selection from being left over.
	                    // Also prevents scene graph crap from being left on the screen.
	                    selection.setSelection(0, newSelection);
	                }
	        		CanvasUtils.sendCommand(source_ctx, Commands.COPY);
	        		CanvasUtils.sendCommand(target_ctx, Commands.PASTE);
	            }
	        });
			
		//}
		
		while(source_ctx.getEventQueue().size() > 0) {
			try {
				Thread.sleep(10);
			} catch (InterruptedException e) {
				throw new DatabaseException(e);
			}
		}

		ThreadUtils.syncExec(source_ctx.getThreadAccess(), new Runnable() {
            @Override
            public void run() {
            }
        });		
	        		
		}
		return true;
    }


}