package org.simantics.modeling;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.InstantiateRequest;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.structural.stubs.StructuralResource2;

public class NewComponentType {
	
	public static Resource createComponentType(WriteGraph graph, Resource library) throws DatabaseException {

        ModelingResources MOD = ModelingResources.getInstance(graph);
        Layer0 L0 = Layer0.getInstance(graph);
        Layer0X L0X = Layer0X.getInstance(graph);
        StructuralResource2 STR = StructuralResource2.getInstance(graph);
        DiagramResource DIA = DiagramResource.getInstance(graph);

        // New component type
        CommonDBUtils.selectClusterSet(graph, library);
        Resource componentType = graph.newResource();
        graph.newClusterSet(componentType);
        CommonDBUtils.selectClusterSet(graph, componentType);
        
        graph.claim(componentType, L0.PartOf, library);
        
        Resource indexRoot = graph.sync(new PossibleIndexRoot(library));

        // Supertype
        Resource supertype = graph.getSingleObject(indexRoot, MOD.StructuralModel_HasComponentTypeSupertype);
        graph.claim(componentType, L0.Inherits, null, supertype);

        // Name
        String defaultName = graph.getRelatedValue(indexRoot, MOD.StructuralModel_HasDefaultComponentTypeName, Bindings.STRING);
        String name = NameUtils.findFreshName(graph, defaultName, library);
        graph.claimLiteral(componentType, L0.HasName, name + "@1");
        graph.claimLiteral(componentType, L0X.HasGeneratedNamePrefix, "");

        // Substructure
        Resource substructureType = graph.getSingleObject(indexRoot, MOD.StructuralModel_HasComponentTypeSubstructureType);
        Resource composite = new InstantiateRequest(substructureType).perform(graph);
        graph.claim(componentType, STR.IsDefinedBy, composite);
        // These are added to give the configuration a proper URI.
        graph.claimLiteral(composite, L0.HasName, "Configuration");
        graph.claim(componentType, L0.ConsistsOf, composite);

        // Attach trigger to keep component type interface structures up-to-date
        Resource diagram = graph.getPossibleObject(composite, MOD.CompositeToDiagram);
        if (diagram != null) {
            Resource componentTypeUpdater = graph.newResource();
            graph.claim(componentTypeUpdater, L0.InstanceOf, null, MOD.ComponentTypeUpdater);
            graph.claim(diagram, L0X.HasTrigger, componentTypeUpdater);
        }

        Resource symbolDiagramType = graph.getPossibleObject(indexRoot, MOD.StructuralModel_HasSymbolDiagramType);
        if(symbolDiagramType == null) symbolDiagramType = DIA.Composite;
        
        // Symbol
        Resource symbol = new ModelingUtils(graph).createSymbol2("Symbol", symbolDiagramType);
        graph.claim(componentType, MOD.ComponentTypeToSymbol, symbol);
        graph.claim(componentType, L0.ConsistsOf, symbol);
        
        CommentMetadata cm = graph.getMetadata(CommentMetadata.class);
        graph.addMetadata(cm.add("Created new user component " + name + ", resource " + componentType));
        
        return componentType;
    }
}