/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.message.ui.test;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.message.DetailStatus;
import org.simantics.message.IDetailStatus;
import org.simantics.message.ILogger;
import org.simantics.message.MessageService;
import org.simantics.message.ReferenceSerializationException;
import org.simantics.message.ui.Activator;
import org.simantics.message.util.MessageUtil;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;

/**
 * @author Tuukka Lehtonen
 */
public class TestResourceStatusHandler extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Resource[] rs = ResourceAdaptionUtils.toResources(HandlerUtil.getCurrentSelection(event));
        ILogger log = MessageService.getDefault();
    
        Session s = SimanticsUI.peekSession();
        if (s == null)
            return null;

        try {
            int code = 0;
            for (Resource r : rs) {
                log.log(new DetailStatus(IDetailStatus.DEBUG, Activator.PLUGIN_ID, code++,
                        "Logged reference to selected resource",
                        NLS.bind(Messages.Test_message, MessageUtil.resource(s, r, "this link")),
                        null));
            }
        } catch (ReferenceSerializationException e) {
            e.printStackTrace();
        }
        
        return null;
    }

}
