/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.message.ui.scheme;

import java.net.URI;

import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.message.IReferenceSerializer;
import org.simantics.message.ReferenceSerializationException;
import org.simantics.message.util.ResourceSerializerUtil;
import org.simantics.ui.SimanticsUI;

/**
 * @author Tuukka Lehtonen
 */
public class ResourceReferenceSerializer implements IReferenceSerializer {

    Session s;

    public ResourceReferenceSerializer() {
        this.s = SimanticsUI.getSession();
    }

    public ResourceReferenceSerializer(Session s) {
        this.s = s;
    }

    @Override
    public boolean handles(Object o) {
        return o instanceof Resource;
    }

    @Override
    public Object deserialize(URI data) throws ReferenceSerializationException {
        return ResourceSerializerUtil.deserialize(s, data);
    }

    @Override
    public URI serialize(Object o) throws ReferenceSerializationException {
        assert handles(o);
        return ResourceSerializerUtil.serialize(s, (Resource) o);
    }

}
