package org.simantics.issues.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class IssueResource {
    
    public final Resource ContinuousIssueSource;
    public final Resource ContinuousIssueSource_lastUpdateRevision;
    public final Resource ContinuousIssueSource_lastUpdateRevision_Inverse;
    public final Resource DynamicIssueSource;
    public final Resource Functions;
    public final Resource Functions_defaultDescription;
    public final Resource Functions_dependencyBaseRealizationFunction;
    public final Resource Functions_standardIssueContexts;
    public final Resource Functions_standardIssuePath;
    public final Resource Functions_standardIssueResource;
    public final Resource Functions_standardIssueSeverity;
    public final Resource Hidden;
    public final Resource Issue;
    public final Resource IssueSource;
    public final Resource IssueSourceType;
    public final Resource IssueSource_HasConstraint;
    public final Resource IssueSource_HasConstraint_Inverse;
    public final Resource IssueSource_Manages;
    public final Resource IssueSource_Manages_Inverse;
    public final Resource IssueSource_Selected;
    public final Resource IssueSource_active;
    public final Resource IssueSource_active_Inverse;
    public final Resource Issue_HasContext;
    public final Resource Issue_HasContext_Inverse;
    public final Resource Issue_HasContexts;
    public final Resource Issue_HasContexts_Inverse;
    public final Resource Issue_HasSeverity;
    public final Resource Issue_HasSeverity_Inverse;
    public final Resource Issue_contexts;
    public final Resource Issue_contexts_Inverse;
    public final Resource Issue_creationTime;
    public final Resource Issue_creationTime_Inverse;
    public final Resource Issue_path;
    public final Resource Issue_path_Inverse;
    public final Resource Issue_resource;
    public final Resource Issue_resource_Inverse;
    public final Resource Issue_severity;
    public final Resource Issue_severity_Inverse;
    public final Resource Resolved;
    public final Resource Severity;
    public final Resource Severity_Error;
    public final Resource Severity_Fatal;
    public final Resource Severity_Info;
    public final Resource Severity_Note;
    public final Resource Severity_Warning;
    public final Resource Sources;
    public final Resource Sources_DependencyTracker;
    public final Resource Sources_DependencyTracker_AnonymousIssue;
    public final Resource Sources_DependencyTracker_HasBaseFunction;
    public final Resource Sources_DependencyTracker_HasBaseFunction_Inverse;
    public final Resource Sources_DependencyTracker_HasConstraint;
    public final Resource Sources_DependencyTracker_HasConstraint_Inverse;
    public final Resource Sources_DependencyTracker_HasExtension;
    public final Resource Sources_DependencyTracker_HasExtension_Inverse;
    public final Resource Sources_DependencyTracker_HasSearchType;
    public final Resource Sources_DependencyTracker_HasSearchType_Inverse;
    public final Resource Sources_DependencyTracker_HasType;
    public final Resource Sources_DependencyTracker_HasType_Inverse;
    public final Resource Sources_DependencyTracker_Issue;
    public final Resource Sources_ListeningDependencyTracker;
    public final Resource UserIssue;
    public final Resource anonymousIssue;
    public final Resource assignConstraint;
    public final Resource constraint;
    public final Resource issue;
    public final Resource listeningConstraint;
    public final Resource listeningConstraint3;
        
    public static class URIs {
        public static final String ContinuousIssueSource = "http://www.simantics.org/Issue-1.2/ContinuousIssueSource";
        public static final String ContinuousIssueSource_lastUpdateRevision = "http://www.simantics.org/Issue-1.2/ContinuousIssueSource/lastUpdateRevision";
        public static final String ContinuousIssueSource_lastUpdateRevision_Inverse = "http://www.simantics.org/Issue-1.2/ContinuousIssueSource/lastUpdateRevision/Inverse";
        public static final String DynamicIssueSource = "http://www.simantics.org/Issue-1.2/DynamicIssueSource";
        public static final String Functions = "http://www.simantics.org/Issue-1.2/Functions";
        public static final String Functions_defaultDescription = "http://www.simantics.org/Issue-1.2/Functions/defaultDescription";
        public static final String Functions_dependencyBaseRealizationFunction = "http://www.simantics.org/Issue-1.2/Functions/dependencyBaseRealizationFunction";
        public static final String Functions_standardIssueContexts = "http://www.simantics.org/Issue-1.2/Functions/standardIssueContexts";
        public static final String Functions_standardIssuePath = "http://www.simantics.org/Issue-1.2/Functions/standardIssuePath";
        public static final String Functions_standardIssueResource = "http://www.simantics.org/Issue-1.2/Functions/standardIssueResource";
        public static final String Functions_standardIssueSeverity = "http://www.simantics.org/Issue-1.2/Functions/standardIssueSeverity";
        public static final String Hidden = "http://www.simantics.org/Issue-1.2/Hidden";
        public static final String Issue = "http://www.simantics.org/Issue-1.2/Issue";
        public static final String IssueSource = "http://www.simantics.org/Issue-1.2/IssueSource";
        public static final String IssueSourceType = "http://www.simantics.org/Issue-1.2/IssueSourceType";
        public static final String IssueSource_HasConstraint = "http://www.simantics.org/Issue-1.2/IssueSource/HasConstraint";
        public static final String IssueSource_HasConstraint_Inverse = "http://www.simantics.org/Issue-1.2/IssueSource/HasConstraint/Inverse";
        public static final String IssueSource_Manages = "http://www.simantics.org/Issue-1.2/IssueSource/Manages";
        public static final String IssueSource_Manages_Inverse = "http://www.simantics.org/Issue-1.2/IssueSource/Manages/Inverse";
        public static final String IssueSource_Selected = "http://www.simantics.org/Issue-1.2/IssueSource/Selected";
        public static final String IssueSource_active = "http://www.simantics.org/Issue-1.2/IssueSource/active";
        public static final String IssueSource_active_Inverse = "http://www.simantics.org/Issue-1.2/IssueSource/active/Inverse";
        public static final String Issue_HasContext = "http://www.simantics.org/Issue-1.2/Issue/HasContext";
        public static final String Issue_HasContext_Inverse = "http://www.simantics.org/Issue-1.2/Issue/HasContext/Inverse";
        public static final String Issue_HasContexts = "http://www.simantics.org/Issue-1.2/Issue/HasContexts";
        public static final String Issue_HasContexts_Inverse = "http://www.simantics.org/Issue-1.2/Issue/HasContexts/Inverse";
        public static final String Issue_HasSeverity = "http://www.simantics.org/Issue-1.2/Issue/HasSeverity";
        public static final String Issue_HasSeverity_Inverse = "http://www.simantics.org/Issue-1.2/Issue/HasSeverity/Inverse";
        public static final String Issue_contexts = "http://www.simantics.org/Issue-1.2/Issue/contexts";
        public static final String Issue_contexts_Inverse = "http://www.simantics.org/Issue-1.2/Issue/contexts/Inverse";
        public static final String Issue_creationTime = "http://www.simantics.org/Issue-1.2/Issue/creationTime";
        public static final String Issue_creationTime_Inverse = "http://www.simantics.org/Issue-1.2/Issue/creationTime/Inverse";
        public static final String Issue_path = "http://www.simantics.org/Issue-1.2/Issue/path";
        public static final String Issue_path_Inverse = "http://www.simantics.org/Issue-1.2/Issue/path/Inverse";
        public static final String Issue_resource = "http://www.simantics.org/Issue-1.2/Issue/resource";
        public static final String Issue_resource_Inverse = "http://www.simantics.org/Issue-1.2/Issue/resource/Inverse";
        public static final String Issue_severity = "http://www.simantics.org/Issue-1.2/Issue/severity";
        public static final String Issue_severity_Inverse = "http://www.simantics.org/Issue-1.2/Issue/severity/Inverse";
        public static final String Resolved = "http://www.simantics.org/Issue-1.2/Resolved";
        public static final String Severity = "http://www.simantics.org/Issue-1.2/Severity";
        public static final String Severity_Error = "http://www.simantics.org/Issue-1.2/Severity/Error";
        public static final String Severity_Fatal = "http://www.simantics.org/Issue-1.2/Severity/Fatal";
        public static final String Severity_Info = "http://www.simantics.org/Issue-1.2/Severity/Info";
        public static final String Severity_Note = "http://www.simantics.org/Issue-1.2/Severity/Note";
        public static final String Severity_Warning = "http://www.simantics.org/Issue-1.2/Severity/Warning";
        public static final String Sources = "http://www.simantics.org/Issue-1.2/Sources";
        public static final String Sources_DependencyTracker = "http://www.simantics.org/Issue-1.2/Sources/DependencyTracker";
        public static final String Sources_DependencyTracker_AnonymousIssue = "http://www.simantics.org/Issue-1.2/Sources/DependencyTracker/AnonymousIssue";
        public static final String Sources_DependencyTracker_HasBaseFunction = "http://www.simantics.org/Issue-1.2/Sources/DependencyTracker/HasBaseFunction";
        public static final String Sources_DependencyTracker_HasBaseFunction_Inverse = "http://www.simantics.org/Issue-1.2/Sources/DependencyTracker/HasBaseFunction/Inverse";
        public static final String Sources_DependencyTracker_HasConstraint = "http://www.simantics.org/Issue-1.2/Sources/DependencyTracker/HasConstraint";
        public static final String Sources_DependencyTracker_HasConstraint_Inverse = "http://www.simantics.org/Issue-1.2/Sources/DependencyTracker/HasConstraint/Inverse";
        public static final String Sources_DependencyTracker_HasExtension = "http://www.simantics.org/Issue-1.2/Sources/DependencyTracker/HasExtension";
        public static final String Sources_DependencyTracker_HasExtension_Inverse = "http://www.simantics.org/Issue-1.2/Sources/DependencyTracker/HasExtension/Inverse";
        public static final String Sources_DependencyTracker_HasSearchType = "http://www.simantics.org/Issue-1.2/Sources/DependencyTracker/HasSearchType";
        public static final String Sources_DependencyTracker_HasSearchType_Inverse = "http://www.simantics.org/Issue-1.2/Sources/DependencyTracker/HasSearchType/Inverse";
        public static final String Sources_DependencyTracker_HasType = "http://www.simantics.org/Issue-1.2/Sources/DependencyTracker/HasType";
        public static final String Sources_DependencyTracker_HasType_Inverse = "http://www.simantics.org/Issue-1.2/Sources/DependencyTracker/HasType/Inverse";
        public static final String Sources_DependencyTracker_Issue = "http://www.simantics.org/Issue-1.2/Sources/DependencyTracker/Issue";
        public static final String Sources_ListeningDependencyTracker = "http://www.simantics.org/Issue-1.2/Sources/ListeningDependencyTracker";
        public static final String UserIssue = "http://www.simantics.org/Issue-1.2/UserIssue";
        public static final String anonymousIssue = "http://www.simantics.org/Issue-1.2/anonymousIssue";
        public static final String assignConstraint = "http://www.simantics.org/Issue-1.2/assignConstraint";
        public static final String constraint = "http://www.simantics.org/Issue-1.2/constraint";
        public static final String issue = "http://www.simantics.org/Issue-1.2/issue";
        public static final String listeningConstraint = "http://www.simantics.org/Issue-1.2/listeningConstraint";
        public static final String listeningConstraint3 = "http://www.simantics.org/Issue-1.2/listeningConstraint3";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public IssueResource(ReadGraph graph) {
        ContinuousIssueSource = getResourceOrNull(graph, URIs.ContinuousIssueSource);
        ContinuousIssueSource_lastUpdateRevision = getResourceOrNull(graph, URIs.ContinuousIssueSource_lastUpdateRevision);
        ContinuousIssueSource_lastUpdateRevision_Inverse = getResourceOrNull(graph, URIs.ContinuousIssueSource_lastUpdateRevision_Inverse);
        DynamicIssueSource = getResourceOrNull(graph, URIs.DynamicIssueSource);
        Functions = getResourceOrNull(graph, URIs.Functions);
        Functions_defaultDescription = getResourceOrNull(graph, URIs.Functions_defaultDescription);
        Functions_dependencyBaseRealizationFunction = getResourceOrNull(graph, URIs.Functions_dependencyBaseRealizationFunction);
        Functions_standardIssueContexts = getResourceOrNull(graph, URIs.Functions_standardIssueContexts);
        Functions_standardIssuePath = getResourceOrNull(graph, URIs.Functions_standardIssuePath);
        Functions_standardIssueResource = getResourceOrNull(graph, URIs.Functions_standardIssueResource);
        Functions_standardIssueSeverity = getResourceOrNull(graph, URIs.Functions_standardIssueSeverity);
        Hidden = getResourceOrNull(graph, URIs.Hidden);
        Issue = getResourceOrNull(graph, URIs.Issue);
        IssueSource = getResourceOrNull(graph, URIs.IssueSource);
        IssueSourceType = getResourceOrNull(graph, URIs.IssueSourceType);
        IssueSource_HasConstraint = getResourceOrNull(graph, URIs.IssueSource_HasConstraint);
        IssueSource_HasConstraint_Inverse = getResourceOrNull(graph, URIs.IssueSource_HasConstraint_Inverse);
        IssueSource_Manages = getResourceOrNull(graph, URIs.IssueSource_Manages);
        IssueSource_Manages_Inverse = getResourceOrNull(graph, URIs.IssueSource_Manages_Inverse);
        IssueSource_Selected = getResourceOrNull(graph, URIs.IssueSource_Selected);
        IssueSource_active = getResourceOrNull(graph, URIs.IssueSource_active);
        IssueSource_active_Inverse = getResourceOrNull(graph, URIs.IssueSource_active_Inverse);
        Issue_HasContext = getResourceOrNull(graph, URIs.Issue_HasContext);
        Issue_HasContext_Inverse = getResourceOrNull(graph, URIs.Issue_HasContext_Inverse);
        Issue_HasContexts = getResourceOrNull(graph, URIs.Issue_HasContexts);
        Issue_HasContexts_Inverse = getResourceOrNull(graph, URIs.Issue_HasContexts_Inverse);
        Issue_HasSeverity = getResourceOrNull(graph, URIs.Issue_HasSeverity);
        Issue_HasSeverity_Inverse = getResourceOrNull(graph, URIs.Issue_HasSeverity_Inverse);
        Issue_contexts = getResourceOrNull(graph, URIs.Issue_contexts);
        Issue_contexts_Inverse = getResourceOrNull(graph, URIs.Issue_contexts_Inverse);
        Issue_creationTime = getResourceOrNull(graph, URIs.Issue_creationTime);
        Issue_creationTime_Inverse = getResourceOrNull(graph, URIs.Issue_creationTime_Inverse);
        Issue_path = getResourceOrNull(graph, URIs.Issue_path);
        Issue_path_Inverse = getResourceOrNull(graph, URIs.Issue_path_Inverse);
        Issue_resource = getResourceOrNull(graph, URIs.Issue_resource);
        Issue_resource_Inverse = getResourceOrNull(graph, URIs.Issue_resource_Inverse);
        Issue_severity = getResourceOrNull(graph, URIs.Issue_severity);
        Issue_severity_Inverse = getResourceOrNull(graph, URIs.Issue_severity_Inverse);
        Resolved = getResourceOrNull(graph, URIs.Resolved);
        Severity = getResourceOrNull(graph, URIs.Severity);
        Severity_Error = getResourceOrNull(graph, URIs.Severity_Error);
        Severity_Fatal = getResourceOrNull(graph, URIs.Severity_Fatal);
        Severity_Info = getResourceOrNull(graph, URIs.Severity_Info);
        Severity_Note = getResourceOrNull(graph, URIs.Severity_Note);
        Severity_Warning = getResourceOrNull(graph, URIs.Severity_Warning);
        Sources = getResourceOrNull(graph, URIs.Sources);
        Sources_DependencyTracker = getResourceOrNull(graph, URIs.Sources_DependencyTracker);
        Sources_DependencyTracker_AnonymousIssue = getResourceOrNull(graph, URIs.Sources_DependencyTracker_AnonymousIssue);
        Sources_DependencyTracker_HasBaseFunction = getResourceOrNull(graph, URIs.Sources_DependencyTracker_HasBaseFunction);
        Sources_DependencyTracker_HasBaseFunction_Inverse = getResourceOrNull(graph, URIs.Sources_DependencyTracker_HasBaseFunction_Inverse);
        Sources_DependencyTracker_HasConstraint = getResourceOrNull(graph, URIs.Sources_DependencyTracker_HasConstraint);
        Sources_DependencyTracker_HasConstraint_Inverse = getResourceOrNull(graph, URIs.Sources_DependencyTracker_HasConstraint_Inverse);
        Sources_DependencyTracker_HasExtension = getResourceOrNull(graph, URIs.Sources_DependencyTracker_HasExtension);
        Sources_DependencyTracker_HasExtension_Inverse = getResourceOrNull(graph, URIs.Sources_DependencyTracker_HasExtension_Inverse);
        Sources_DependencyTracker_HasSearchType = getResourceOrNull(graph, URIs.Sources_DependencyTracker_HasSearchType);
        Sources_DependencyTracker_HasSearchType_Inverse = getResourceOrNull(graph, URIs.Sources_DependencyTracker_HasSearchType_Inverse);
        Sources_DependencyTracker_HasType = getResourceOrNull(graph, URIs.Sources_DependencyTracker_HasType);
        Sources_DependencyTracker_HasType_Inverse = getResourceOrNull(graph, URIs.Sources_DependencyTracker_HasType_Inverse);
        Sources_DependencyTracker_Issue = getResourceOrNull(graph, URIs.Sources_DependencyTracker_Issue);
        Sources_ListeningDependencyTracker = getResourceOrNull(graph, URIs.Sources_ListeningDependencyTracker);
        UserIssue = getResourceOrNull(graph, URIs.UserIssue);
        anonymousIssue = getResourceOrNull(graph, URIs.anonymousIssue);
        assignConstraint = getResourceOrNull(graph, URIs.assignConstraint);
        constraint = getResourceOrNull(graph, URIs.constraint);
        issue = getResourceOrNull(graph, URIs.issue);
        listeningConstraint = getResourceOrNull(graph, URIs.listeningConstraint);
        listeningConstraint3 = getResourceOrNull(graph, URIs.listeningConstraint3);
    }
    
    public static IssueResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        IssueResource ret = session.peekService(IssueResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new IssueResource(qc.getIndependentGraph(graph));
            session.registerService(IssueResource.class, ret);
        }
        return ret;
    }
    
    public static IssueResource getInstance(RequestProcessor session) throws DatabaseException {
        IssueResource ret = session.peekService(IssueResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<IssueResource>() {
                public IssueResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new IssueResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(IssueResource.class, ret);
        }
        return ret;
    }
    
}

