package org.simantics.image.ui.internal;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.simantics.image"; //$NON-NLS-1$

	// The shared instance
	private static Activator plugin;

	public static ImageDescriptor IMAGE_ICON;
    public static ImageDescriptor IMAGES_ICON;
    public static ImageDescriptor ADD_IMAGE_ICON;

	/**
	 * The constructor
	 */
	public Activator() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
		
        Bundle bundle = context.getBundle();

		IMAGE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/image.png"));
		IMAGES_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/images.png"));
		ADD_IMAGE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/add_image.png"));
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}

}
