package org.simantics.image.ui;

import java.util.Vector;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.diagram.function.PredefinedVariables;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.image2.ontology.ImageResource;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.project.ontology.ProjectResource;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class LinkSvgImage {

    public static void linkSVGImage(WriteGraph graph, final Resource parent, final Resource child) {

        final String[] uri = {null};
        final String[] msg = {null};
        final String errmsg = "Creation of image reference failed. Activate an experiment and try to copy and paste an image again.";

        try {
            graph.syncRequest(new ReadRequest() {
                @Override
                public void run(ReadGraph g) throws DatabaseException {
                    if (parent == null || child == null) {
                        msg[0] = errmsg;
                        return;
                    }
                    //Layer0 L0 = Layer0.getInstance(g);
                    ImageResource IMG = ImageResource.getInstance(g);
                    if (!g.isInstanceOf(child, IMG.SvgImage)){
                        msg[0] = errmsg;
                        return;
                    }

                    Variable parentV = Variables.getVariable(g, parent);
                    if (parentV == null){
                        msg[0] = errmsg;
                        return;
                    }

                    Vector<Variable> grandOfParent = new Vector<Variable>();
                    Variable tmp = parentV;
                    do {
                        grandOfParent.add(0, tmp);
                        tmp = tmp.getParent(g);
                    }
                    while (tmp != null);

//                  System.err.println(parentV.getURI(g));
//                  String parentUri = parentV.getURI(g);

                    Variable childV = Variables.getVariable(g, child);
                    String childUri = null;
                    if (childV == null){
                        msg[0] = errmsg;
                        return;
                    }

                    Vector<Variable> grandOfChild = new Vector<Variable>();
                    tmp = childV;
                    do {
                        grandOfChild.add(0, tmp);
                        tmp = tmp.getParent(g);
                    }
                    while (tmp != null);

                    int k = -1; // index of the most nearest common parent
                    int maxLen = (grandOfChild.size() < grandOfParent.size())? grandOfChild.size() : grandOfParent.size();
                    for (int i = 0;i < maxLen; i++){
                        if (grandOfChild.get(i).equals(grandOfParent.get(i)))
                            k++;
                        else
                            break;
                    }
                    if (k == -1) // no common parent
                    {
                        msg[0] = errmsg;
                        return;
                    }
                    //StructuralResource2 STR = StructuralResource2.getInstance(g);
                    SimulationResource SIMU = SimulationResource.getInstance(g);
                    ProjectResource PROJ = ProjectResource.getInstance(g);
                    Template2dResource TEPLATE2D = Template2dResource.getInstance(g);
                    Resource root = g.getRootLibrary();;
                    Resource type = null;
                    String predefined = null;
                    Resource res = null;
                    for (;k >= 0;k--){
                        tmp = grandOfChild.get(k);
                        res = tmp.getRepresents(g);
                        if (res.equals(root)){
                            predefined = PredefinedVariables.root;
                            break;
                        }
                        type = g.getPossibleType(res, SIMU.Model);
                        if (type != null){
                            predefined = PredefinedVariables.model;
                            break;
                        }
                        type = g.getPossibleType(res, PROJ.Project);
                        if (type != null){
                            predefined = PredefinedVariables.project;
                            break;
                        }
                        type = g.getPossibleType(res, TEPLATE2D.DrawingTemplate);
                        if (type != null){
                            predefined = PredefinedVariables.template;
                            break;
                        }
                    }
                    if (predefined == null) // no predefined common parent
                    {
                        msg[0] = errmsg;
                        return;
                    }
                    Variable resV = Variables.getVariable(g, res);
                    String resUri = resV.getURI(g);

                    childUri = childV.getURI(g);
//                  System.err.println(childUri);

                    Resource childModel = Variables.getModel(g, childV);
                    Resource parentModel = Variables.getModel(g, parentV);
                    if (childModel == null || parentModel == null){
                        msg[0] = errmsg;
                        return;
                    }

                    if (!parentModel.equals(childModel)){
                        msg[0] = errmsg;
                        return;
                    }

//                  Variable modelV = Variables.getVariable(g, childModel);
//                  if (modelV == null){
//                      msg[0] = errmsg[0];
//                      return;
//                  }
//
//                  String modelUri = modelV.getURI(g);

                    if (childUri.startsWith(resUri)){
                        uri[0] = childUri.substring(resUri.length());
                        uri[0] = "pre:/" + predefined + uri[0];
//                      System.err.println(uri);
                    }
                }
            });
            graph.syncRequest(new WriteRequest() {
                @Override
                public void perform(WriteGraph g) throws DatabaseException {
                    if (uri == null || parent == null){
                        msg[0] = errmsg;
                        return;
                    }
                    DiagramResource DIA = DiagramResource.getInstance(g);
                    Template2dResource TEMPLATE2D = Template2dResource.getInstance(g);

                    Resource var = g.getPossibleObject(parent, DIA.Scenegraph_SVGImage_document);
                    if (var == null){
                        msg[0] = "Creation of image reference failed. Only SVG images are supported for now.";
                        return;
                    }

                    g.claimLiteral(var, TEMPLATE2D.Profiles_VariableReference_path, uri[0] + "#data", Bindings.STRING);
                }
            });
            if (msg[0] != null){
                ShowMessage.showWarning("Warning", msg[0]);
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }

    }


}
