package org.simantics.help.ui;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.help.core.HelpUtils;
import org.simantics.layer0.Layer0;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.utils.logging.TimeLogger;

public class HelpFileDocumentProvider extends AbstractDocumentProvider {

    private Resource resource;
    private String currentText;
    private boolean errorHappened;

    @Override
    protected IDocument createDocument(Object element) throws CoreException {
        IResourceEditorInput input = (IResourceEditorInput) element;
        resource = input.getResource();
        try {
            return Simantics.getSession().syncRequest(new UniqueRead<Document>() {
                @Override
                public Document perform(ReadGraph graph) throws DatabaseException {
                    currentText = HelpUtils.readHelpFileContents(graph, resource);
                    errorHappened = false;
                    return new Document(currentText != null ? currentText : "");
                }
            });
        } catch (DatabaseException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            errorHappened = true;
            return new Document(sw.toString());
        }
    }

    @Override
    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return null;
    }

    @Override
    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        TimeLogger.resetTimeAndLog("HelpFileDocumentProvider.doSaveDocument");
        currentText = document.get();
        Simantics.getSession().asyncRequest(new WriteRequest() {
            @Override
            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                HelpUtils.saveHelpFileContents(graph, resource, currentText);
                Layer0Utils.addCommentMetadata(graph, "Saved SCL Module " + graph.getRelatedValue2(resource, Layer0.getInstance(graph).HasName, Bindings.STRING));
            }
        });
    }

    @Override
    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }
    
    @Override
    public boolean isModifiable(Object element) {
        return !errorHappened;
    }
    
    @Override
    public boolean isReadOnly(Object element) {
        return errorHappened;
    }

    @Override
    public boolean canSaveDocument(Object element) {
        return !errorHappened && !getDocument(element).get().equals(currentText);
    }

}
