/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.representation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;

public class TransferableGraphUtils {
    public static Collection<Identity> getRoots(TransferableGraph1 tg) {
        ArrayList<Identity> result = new ArrayList<Identity>();
        Identity[] identityArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            if (id.definition instanceof Root) {
                result.add(id);
            }
            ++n2;
        }
        return result;
    }

    public static Identity findRootWithName(TransferableGraph1 tg, String name) {
        Identity[] identityArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            if (id.definition instanceof Root) {
                Root ext = (Root)id.definition;
                if (ext.name.equals(name)) {
                    return id;
                }
            }
            ++n2;
        }
        return null;
    }

    public static Identity findExternalWithName(TransferableGraph1 tg, String name) {
        Identity[] identityArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            if (id.definition instanceof External) {
                External ext = (External)id.definition;
                if (ext.name.equals(name)) {
                    return id;
                }
            }
            ++n2;
        }
        return null;
    }

    public static Identity findExternalWithNameAndParent(TransferableGraph1 tg, int parent, String name) {
        Identity[] identityArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            if (id.definition instanceof External) {
                External ext = (External)id.definition;
                if (ext.name.equals(name) && ext.parent == parent) {
                    return id;
                }
            }
            ++n2;
        }
        return null;
    }

    public static Identity findExternal(TransferableGraph1 tg, String uri) {
        String[] tokens;
        Identity identity = TransferableGraphUtils.findExternalWithName(tg, "http:/");
        if (identity == null) {
            identity = TransferableGraphUtils.findExternalWithName(tg, "");
        }
        if (identity == null) {
            identity = TransferableGraphUtils.findRootWithName(tg, "");
        }
        if ("http:/".equals(uri)) {
            return identity;
        }
        String[] stringArray = tokens = uri.substring("http://".length()).split("/");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            identity = TransferableGraphUtils.findExternalWithNameAndParent(tg, identity.resource, token);
            ++n2;
        }
        return identity;
    }

    public static Collection<Identity> getChildren(TransferableGraph1 tg, Identity parent) {
        ArrayList<Identity> result = new ArrayList<Identity>();
        System.err.println("children for " + parent.resource);
        Identity[] identityArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            if (id.definition instanceof Internal) {
                Internal internal = (Internal)id.definition;
                System.err.println("internal with parent " + internal.parent);
                if (internal.parent == parent.resource) {
                    result.add(id);
                }
            }
            ++n2;
        }
        TransferableGraphUtils.findExternal(tg, "http://www.simantics.org/Layer0-1.1/ConsistsOf");
        int i = 0;
        while (i < tg.statements.length) {
            if (tg.statements[i] == parent.resource) {
                System.err.println("related to parent  " + tg.statements[i + 3]);
            }
            i += 4;
        }
        return result;
    }

    public static int getPossibleObject(TransferableGraph1 tg, Identity subject, String predicate) {
        Identity p = TransferableGraphUtils.findExternal(tg, predicate);
        if (p == null) {
            return 0;
        }
        int result = 0;
        int i = 0;
        while (i < tg.statements.length) {
            if (tg.statements[i] == subject.resource && tg.statements[i + 1] == p.resource) {
                if (result != 0) {
                    return 0;
                }
                result = tg.statements[i + 3];
            }
            i += 4;
        }
        return result;
    }

    public static Map<Identity, String> getNames(TransferableGraph1 tg, Collection<Identity> ids) {
        HashMap<Identity, String> result = new HashMap<Identity, String>();
        for (Identity id : ids) {
            if (!(id.definition instanceof Internal)) continue;
            Internal internal = (Internal)id.definition;
            result.put(id, internal.name);
        }
        return result;
    }

    public static String getName(TransferableGraph1 tg, Identity id) {
        return TransferableGraphUtils.getName(id);
    }

    public static String getName(Identity id) {
        if (id.definition instanceof Internal) {
            Internal internal = (Internal)id.definition;
            return internal.name;
        }
        if (id.definition instanceof External) {
            External external = (External)id.definition;
            return external.name;
        }
        if (id.definition instanceof Root) {
            Root root = (Root)id.definition;
            return root.name;
        }
        Optional optional = (Optional)id.definition;
        return optional.name;
    }

    public static String getRootType(Identity id) {
        if (id.definition instanceof Root) {
            Root root = (Root)id.definition;
            return root.type;
        }
        throw new IllegalArgumentException("Expected root, got " + id);
    }

    public static Value findValue(TransferableGraph1 tg, int subject) {
        Value[] valueArray = tg.values;
        int n = tg.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            if (v.resource == subject) {
                return v;
            }
            ++n2;
        }
        return null;
    }

    public static String getURI(TransferableGraph1 tg, int id) {
        return TransferableGraphUtils.getURI(tg.resourceCount, tg.identities, id);
    }

    public static String getURI(int resourceCount, Identity[] identities, int id) {
        Identity[] identityArray = identities;
        int n = identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity identity = identityArray[n2];
            if (identity.resource == id) {
                IdentityDefinition definition = identity.definition;
                if (definition instanceof External) {
                    External def = (External)definition;
                    if (def.parent == -1) {
                        return "http:/";
                    }
                    return String.valueOf(TransferableGraphUtils.getURI(resourceCount, identities, def.parent)) + "/" + def.name;
                }
                if (definition instanceof Root) {
                    Root def = (Root)definition;
                    return def.name;
                }
                if (definition instanceof Internal) {
                    Internal def = (Internal)definition;
                    System.err.println("External URI error: parent was internal '" + def.name + "'");
                    return "";
                }
                return "";
            }
            ++n2;
        }
        return "<internal reference " + id + ">:";
    }
}

