/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.matching;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.Comparator;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.graph.matching.GraphMatching;
import org.simantics.graph.matching.GraphMatchingStrategy;
import org.simantics.graph.matching.Stat;

public enum CanonicalizingMatchingStrategy implements GraphMatchingStrategy
{
    INSTANCE;

    private static final Comparator<Vertex> VERTEX_COMPARATOR;

    static {
        VERTEX_COMPARATOR = new Comparator<Vertex>(){

            @Override
            public int compare(Vertex o1, Vertex o2) {
                int pos1 = o1.pos;
                int pos2 = o2.pos;
                if (pos1 < pos2) {
                    return -1;
                }
                if (pos1 > pos2) {
                    return 1;
                }
                Stat[] stats1 = o1.stats;
                Stat[] stats2 = o2.stats;
                if (stats1.length < stats2.length) {
                    return -1;
                }
                if (stats1.length > stats2.length) {
                    return 1;
                }
                int i = 0;
                while (i < stats1.length) {
                    int comp = Stat.STAT_COMPARATOR.compare(stats1[i], stats2[i]);
                    if (comp != 0) {
                        return comp;
                    }
                    ++i;
                }
                if (o1.graph < o2.graph) {
                    return -1;
                }
                if (o1.graph > o2.graph) {
                    return 1;
                }
                if (o1.original < o2.original) {
                    return -1;
                }
                if (o1.original > o2.original) {
                    return 1;
                }
                return 0;
            }
        };
    }

    private static int[] generateMapA(int[] aToB) {
        int[] map = new int[aToB.length];
        int i = 0;
        while (i < aToB.length) {
            int c = aToB[i];
            map[i] = c >= 0 ? -1 - c : 0;
            ++i;
        }
        return map;
    }

    private static int[] generateMapB(int[] bToA) {
        int[] map = new int[bToA.length];
        int i = 0;
        while (i < bToA.length) {
            int c = bToA[i];
            map[i] = c >= 0 ? -1 - i : 0;
            ++i;
        }
        return map;
    }

    private static Vertex[] generateVertices(int graph, int[] map, Stat[][] statements) {
        int size = 0;
        int s = 0;
        while (s < map.length) {
            if (map[s] == 0) {
                ++size;
            }
            ++s;
        }
        Vertex[] vertices = new Vertex[size];
        int s2 = 0;
        int i = 0;
        while (s2 < map.length) {
            if (map[s2] == 0) {
                Stat[] ns = statements[s2];
                Stat[] stats = new Stat[ns.length];
                int j = 0;
                while (j < ns.length) {
                    Stat n = ns[j];
                    stats[j] = new Stat(map[n.p], map[n.o]);
                    ++j;
                }
                Arrays.sort(stats, Stat.STAT_COMPARATOR);
                vertices[i++] = new Vertex(graph, s2, 0, stats);
            }
            ++s2;
        }
        return vertices;
    }

    private static void updateVertices(Vertex[] vertices, int[] map, Stat[][] statements) {
        int i = 0;
        while (i < vertices.length) {
            int s = vertices[i].original;
            Stat[] ns = statements[s];
            Stat[] stats = vertices[i].stats;
            int j = 0;
            while (j < ns.length) {
                Stat n = ns[j];
                Stat stat = stats[j];
                stat.p = map[n.p];
                stat.o = map[n.o];
                ++j;
            }
            Arrays.sort(stats, Stat.STAT_COMPARATOR);
            ++i;
        }
    }

    private static Vertex[] concat(Vertex[] as, Vertex[] bs) {
        Vertex[] result = new Vertex[as.length + bs.length];
        System.arraycopy(as, 0, result, 0, as.length);
        System.arraycopy(bs, 0, result, as.length, bs.length);
        return result;
    }

    static boolean equals(Stat[] stats1, Stat[] stats2) {
        if (stats1.length != stats2.length) {
            return false;
        }
        int i = 0;
        while (i < stats1.length) {
            Stat stat1 = stats1[i];
            Stat stat2 = stats2[i];
            if (stat1.p != stat2.p || stat1.o != stat2.o) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean updatePositions(Vertex[] can) {
        boolean modified = false;
        int oldPos = can[0].pos;
        Vertex oldVertex = can[0];
        int i = 1;
        while (i < can.length) {
            Vertex curVertex = can[i];
            int curPos = curVertex.pos;
            if (curPos == oldPos) {
                if (CanonicalizingMatchingStrategy.equals(oldVertex.stats, curVertex.stats)) {
                    curVertex.pos = oldVertex.pos;
                } else {
                    curVertex.pos = i;
                    modified = true;
                }
            } else {
                oldPos = curPos;
            }
            oldVertex = curVertex;
            ++i;
        }
        return modified;
    }

    private static void updateMap(Vertex[] vertices, int[] map) {
        Vertex[] vertexArray = vertices;
        int n = vertices.length;
        int n2 = 0;
        while (n2 < n) {
            Vertex vertex = vertexArray[n2];
            map[vertex.original] = vertex.pos;
            ++n2;
        }
    }

    private static int[] groupPositions(Vertex[] can) {
        TIntArrayList result = new TIntArrayList();
        int i = 0;
        while (i < can.length) {
            if (can[i].pos == i) {
                result.add(i);
            }
            ++i;
        }
        result.add(can.length);
        return result.toArray();
    }

    private boolean separateByValues(Vertex[] can, int begin, int end, Variant[] aValues, Variant[] bValues) {
        int valueId;
        int valueCount = 0;
        TObjectIntHashMap valueIds = new TObjectIntHashMap();
        int[] ids = new int[end - begin];
        int i = begin;
        while (i < end) {
            Vertex v = can[i];
            Variant value = v.graph == 0 ? aValues[v.original] : bValues[v.original];
            valueId = valueIds.get((Object)value);
            if (valueId == 0) {
                valueIds.put((Object)value, ++valueCount);
                ids[i - begin] = valueCount - 1;
            } else {
                ids[i - begin] = valueId - 1;
            }
            ++i;
        }
        if (valueCount > 1) {
            Vertex[] vs = Arrays.copyOfRange(can, begin, end);
            int[] temp = new int[valueCount];
            int[] nArray = ids;
            int n = ids.length;
            valueId = 0;
            while (valueId < n) {
                int id;
                int n2 = id = nArray[valueId];
                temp[n2] = temp[n2] + 1;
                ++valueId;
            }
            int cur = begin;
            int i2 = 0;
            while (i2 < temp.length) {
                int count = temp[i2];
                temp[i2] = cur;
                cur += count;
                ++i2;
            }
            i2 = 0;
            while (i2 < ids.length) {
                vs[i2].pos = temp[ids[i2]];
                ++i2;
            }
            i2 = 0;
            while (i2 < ids.length) {
                int n3 = ids[i2];
                int n4 = temp[n3];
                temp[n3] = n4 + 1;
                can[n4] = vs[i2];
                ++i2;
            }
            return true;
        }
        return false;
    }

    private boolean separateByValues(Vertex[] can, int[] groupPos, Variant[] aValues, Variant[] bValues) {
        boolean modified = false;
        int i = 0;
        while (i < groupPos.length - 1) {
            int end = groupPos[i + 1];
            int begin = groupPos[i];
            if (end - begin > 2) {
                modified |= this.separateByValues(can, begin, end, aValues, bValues);
            }
            ++i;
        }
        return modified;
    }

    private boolean hasBigGroups(Vertex[] can, int[] groupPos) {
        int i = 0;
        while (i < groupPos.length - 1) {
            int end = groupPos[i + 1];
            int begin = groupPos[i];
            if (end - begin > 2 && can[begin].graph == 0 && can[end - 1].graph == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void guessIsomorphism(Vertex[] can, int[] groupPos) {
        UnionFind uf = new UnionFind(can.length);
        int i = 0;
        while (i < can.length) {
            uf.merge(i, can[i].pos);
            Stat[] statArray = can[i].stats;
            int n = can[i].stats.length;
            int n2 = 0;
            while (n2 < n) {
                Stat stat = statArray[n2];
                if (stat.p >= 0) {
                    uf.merge(i, stat.p);
                }
                if (stat.o >= 0) {
                    uf.merge(i, stat.o);
                }
                ++n2;
            }
            ++i;
        }
        TIntHashSet done = new TIntHashSet();
        int i2 = 0;
        while (i2 < groupPos.length - 1) {
            int c;
            int end = groupPos[i2 + 1];
            int begin = groupPos[i2];
            if (end - begin > 2 && can[begin].graph == 0 && can[end - 1].graph == 1 && done.add(c = uf.canonical(begin))) {
                int middle = begin + 1;
                while (can[middle].graph == 0) {
                    ++middle;
                }
                int j = 0;
                while (begin + j < middle && middle + j < end) {
                    can[begin + j].pos = begin + j * 2;
                    can[middle + j].pos = begin + j * 2;
                    ++j;
                }
                int pos = begin + j * 2;
                while (begin + j < middle) {
                    can[begin + j].pos = pos;
                    ++j;
                }
                while (middle + j < end) {
                    can[middle + j].pos = pos;
                    ++j;
                }
            }
            ++i2;
        }
    }

    @Override
    public void applyTo(GraphMatching matching) {
        if (matching.size == matching.aGraph.resourceCount || matching.size == matching.bGraph.resourceCount) {
            return;
        }
        long begin1 = System.nanoTime();
        int[] aMap = CanonicalizingMatchingStrategy.generateMapA(matching.aToB);
        int[] bMap = CanonicalizingMatchingStrategy.generateMapB(matching.bToA);
        Vertex[] aVertices = CanonicalizingMatchingStrategy.generateVertices(0, aMap, matching.aGraph.statements);
        Vertex[] bVertices = CanonicalizingMatchingStrategy.generateVertices(1, bMap, matching.bGraph.statements);
        Vertex[] can = CanonicalizingMatchingStrategy.concat(aVertices, bVertices);
        int[] groupPos = null;
        boolean doneSeparationByValues = false;
        while (true) {
            long begin2 = System.nanoTime();
            Arrays.sort(can, VERTEX_COMPARATOR);
            long begin3 = System.nanoTime();
            if (!CanonicalizingMatchingStrategy.updatePositions(can)) {
                groupPos = CanonicalizingMatchingStrategy.groupPositions(can);
                if (!this.hasBigGroups(can, groupPos)) break;
                boolean modified = false;
                if (!doneSeparationByValues) {
                    modified = this.separateByValues(can, groupPos, matching.aGraph.values, matching.bGraph.values);
                    doneSeparationByValues = true;
                }
                if (!modified) {
                    CanonicalizingMatchingStrategy.guessIsomorphism(can, groupPos);
                }
            }
            long begin4 = System.nanoTime();
            CanonicalizingMatchingStrategy.updateMap(aVertices, aMap);
            CanonicalizingMatchingStrategy.updateMap(bVertices, bMap);
            long begin5 = System.nanoTime();
            CanonicalizingMatchingStrategy.updateVertices(aVertices, aMap, matching.aGraph.statements);
            CanonicalizingMatchingStrategy.updateVertices(bVertices, bMap, matching.bGraph.statements);
        }
        int i = 0;
        while (i < groupPos.length - 1) {
            int end = groupPos[i + 1];
            int begin = groupPos[i];
            if (end - begin == 2) {
                Vertex a = can[begin];
                Vertex b = can[end - 1];
                if (a.graph == 0 && b.graph == 1) {
                    matching.map(a.original, b.original);
                }
            }
            ++i;
        }
    }

    static class TByteArrayIntHashMap
    extends TObjectIntHashMap<byte[]> {
        TByteArrayIntHashMap() {
        }

        protected boolean equals(Object one, Object two) {
            return Arrays.equals((byte[])one, (byte[])two);
        }

        protected int hash(Object obj) {
            return Arrays.hashCode((byte[])obj);
        }
    }

    static class UnionFind {
        int[] canonical;

        public UnionFind(int size) {
            this.canonical = new int[size];
            int i = 0;
            while (i < size) {
                this.canonical[i] = i;
                ++i;
            }
        }

        public int canonical(int a) {
            int c;
            int b = this.canonical[a];
            if (b != a && b != (c = this.canonical[b])) {
                this.canonical[b] = c = this.canonical(c);
                this.canonical[a] = c;
                return c;
            }
            return b;
        }

        public void merge(int a, int b) {
            a = this.canonical(a);
            this.canonical[a] = b = this.canonical(b);
        }
    }

    private static class Vertex {
        int graph;
        int original;
        int pos;
        Stat[] stats;

        public Vertex(int graph, int original, int pos, Stat[] stats) {
            this.graph = graph;
            this.original = original;
            this.pos = pos;
            this.stats = stats;
        }
    }
}

