package org.simantics.graph.compiler.internal.validation;

import java.util.Collection;

import org.simantics.graph.compiler.GraphCompilerPreferences;
import org.simantics.graph.compiler.internal.store.LocationStore;
import org.simantics.graph.compiler.internal.templates.TemplateDefinitionStore;
import org.simantics.graph.query.Res;
import org.simantics.graph.store.GraphStore;
import org.simantics.graph.store.StatementCollision;
import org.simantics.ltk.Problem;

public class ReportCollisions implements Runnable {
    GraphCompilerPreferences preferences;
	Collection<Problem> problems;
	GraphStore store;

	public ReportCollisions(
			GraphCompilerPreferences preferences, Collection<Problem> problems,
			GraphStore store) {
	    this.preferences = preferences;
		this.problems = problems;
		this.store = store;
	}
	
	private static String abbreviateURI(Res res) {
	    if(res == null)
	        return "null";
	    String uri = res.toString();
	    return uri.replace("http://www.simantics.org/", "");
	}
	
	@Override
	public void run() {
		LocationStore locations = store.getStore(LocationStore.class);
		for(int c : store.values.getCollisions().toArray())
			problems.add(new Problem(
					locations.getLocation(c), 
					"Two literal values are given for the same resource."));
		for(int c : store.identities.getCollisions().toArray())
			problems.add(new Problem(
					locations.getLocation(c), 
					"Two different identities are given for the same resource."));
		for(int c : store.getStore(TemplateDefinitionStore.class).getCollisions().toArray())
			problems.add(new Problem(
					locations.getLocation(c), 
					"Two template definitions are given for the same resource."));
		if(preferences.validate)
		    for(StatementCollision collision : store.statements.getCollisions()) {
		        problems.add(new Problem(
		                locations.getLocation(collision.subject), 
		                "The same statement is defined " + collision.count + " times: " +
		                        abbreviateURI(store.idToRes(collision.subject)) + ", " +
		                        abbreviateURI(store.idToRes(collision.predicate)) + ", " +
		                        abbreviateURI(store.idToRes(collision.object))));
		    }
	}
	
}
