package org.simantics.graph.compiler.internal.templates;

import gnu.trove.map.hash.TIntIntHashMap;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.graph.store.IStore;
import org.simantics.graph.store.IndexMappingUtils;

public class TemplateInstanceStore implements IStore {
	ArrayList<int[]> templateInstances;

	public TemplateInstanceStore(ArrayList<int[]> templateInstances) {
		this.templateInstances = templateInstances;
	}
	
	public TemplateInstanceStore() {
		this(new ArrayList<int[]>());
	}

	@Override
	public void map(final TIntIntHashMap map) {
		for(int[] templateInstance : templateInstances)
			IndexMappingUtils.map(map, templateInstance);
	}
	
	public Collection<int[]> getTemplateInstances() {
		return templateInstances;
	}

	public void add(int[] templateInstance) {
		templateInstances.add(templateInstance);		
	}	
}
