package org.simantics.graph.compiler.internal.templates;

import gnu.trove.map.hash.TIntIntHashMap;

import java.util.Collection;

import org.simantics.graph.compiler.internal.procedures.Compactify;
import org.simantics.graph.compiler.internal.procedures.ConvertPreValues;
import org.simantics.graph.compiler.internal.procedures.DefaultValueTyping;
import org.simantics.graph.compiler.internal.procedures.MergeEqualResources;
import org.simantics.graph.compiler.internal.store.LocationStore;
import org.simantics.graph.query.CompositeGraph;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.TransferableGraphConversion;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.store.GraphStore;
import org.simantics.ltk.Problem;

public class TemplateDefinition {
	String[] parameters;
	int[] correspondence;
	GraphStore template;
	
	public TemplateDefinition(String[] parameters, int[] correspondence,
			GraphStore template) {
		this.parameters = parameters;
		this.correspondence = correspondence;
		this.template = template;
	}

	public String[] getParameters() {
		return parameters;
	}
	
	public GraphStore getTemplate() {
		return template;
	}

	public void map(TIntIntHashMap map) {
		for(int i=0;i<correspondence.length;i+=2)
			if(map.containsKey(correspondence[i]))
				correspondence[i] = map.get(correspondence[i]);
	}
	
	public TransferableGraph1 convert(CompositeGraph graph, GraphStore parent, Collection<Problem> problems) {
		LocationStore locations = template.getStore(LocationStore.class);
		for(int i=0;i<correspondence.length;i+=2) {
			int parentId = correspondence[i];
			int childId = correspondence[i+1];
			Path path = parent.identities.idToPath(parentId);
			if(path == null) {
				problems.add(
						new Problem(locations.getLocation(childId), 
						"Template can refer only to resources that have URIs."));
			}
			else
				template.identities.definePath(path, childId);
		}
		new MergeEqualResources(graph.getPaths(), template).run();
		new Compactify(template).run();
		new DefaultValueTyping(graph.getPaths(), template).run();	
		
		graph.addFragment(template);
		new ConvertPreValues(graph, template, problems).run();
		TransferableGraph1 transferableGraph = TransferableGraphConversion.convert(template);
		graph.undoAddFragment();
		
		//transferableGraph.print();
		
		return transferableGraph;
	}
}
