package org.simantics.graph.compiler.internal.templates;

import gnu.trove.map.hash.THashMap;

import org.simantics.graph.query.Path;
import org.simantics.graph.query.PathChild;
import org.simantics.graph.query.Paths;


public class BuiltinTemplates {	
	public final THashMap<Path, ITemplate> TEMPLATES = 
		new THashMap<Path, ITemplate>();
	
	public void add(Path path, ITemplate template) {
		TEMPLATES.put(path, template);
	}
	
	public BuiltinTemplates(Paths paths) {
		add(new PathChild("new", paths.Layer0), NewTemplate.INSTANCE);
		add(new PathChild("list", paths.Layer0), ListTemplate.INSTANCE);
		add(new PathChild("orderedSet", paths.Layer0), OrderedSetTemplate.INSTANCE);
		add(new PathChild("loadBytes", paths.Layer0), LoadBytesTemplate.INSTANCE);
		add(new PathChild("loadString", paths.Layer0), LoadStringTemplate.INSTANCE);
		add(new PathChild("loadDataValue", paths.Layer0), LoadDataValueTemplate.INSTANCE);
	}
}
