package org.simantics.graph.compiler.internal.store;

import gnu.trove.map.hash.TIntIntHashMap;

import java.util.ArrayList;
import java.util.List;

import org.simantics.graph.compiler.SourceInfo;
import org.simantics.graph.compiler.SourceInfo.DefinitionPosition;
import org.simantics.graph.compiler.SourceInfo.SourceFile;
import org.simantics.graph.compiler.SourceInfo.Variable;
import org.simantics.graph.store.IStore;

public class VariableStore implements IStore {
	
	public List<SourceFile> sourceFiles = new ArrayList<SourceFile>();
	
	@Override
	public void map(TIntIntHashMap map) {
		for(SourceFile file : sourceFiles) {
			for(Variable variable : file.variables)
				if(map.contains(variable.resource))
					variable.resource = map.get(variable.resource);
			for(DefinitionPosition pos : file.definitionPositions)
				if(map.contains(pos.resource))
					pos.resource = map.get(pos.resource);
		}
	}
		
	public SourceInfo getSourceInfo() {		
		return new SourceInfo(sourceFiles);
	}

	public void addSourceFile(SourceFile sourceFile) {
		sourceFiles.add(sourceFile);
	}

}
