package org.simantics.graph.compiler.internal.resourceFiles;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.simantics.graph.IResourceFile;

import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;

public class ResourceFile implements IResourceFile {
    private final static Charset UTF8 = Charset.forName("UTF-8");
    
	String packageName;
	String className;
	List<ResourceRef> resources;
	
	public ResourceFile(String packageName, String className,
			List<ResourceRef> resources) {
		this.packageName = packageName;
		this.className = className;
		this.resources = resources;
	}

	/* (non-Javadoc)
	 * @see org.simantics.graph.resourceFiles.IResourceFile#getPackageName()
	 */
	@Override
	public String getPackageName() {
		return packageName;
	}
	
	/* (non-Javadoc)
	 * @see org.simantics.graph.resourceFiles.IResourceFile#getClassName()
	 */
	@Override
	public String getClassName() {
		return className;
	}
	
	public Collection<ResourceRef> getResources() {
		return resources;
	}
	
	private static Configuration configuration = null;
	private static Configuration getConfiguration() {
		if(configuration == null) {
			configuration = new Configuration();
			configuration.setTemplateLoader(
					new URLTemplateLoader() {						
						@Override
						protected URL getURL(String name) {
							return ResourceFile.class.getResource(name);
						}
					});
			configuration.setObjectWrapper(new DefaultObjectWrapper());
		}
		return configuration;
	}
	
	/* (non-Javadoc)
	 * @see org.simantics.graph.resourceFiles.IResourceFile#write(java.io.Writer)
	 */
	@Override
	public void write(Writer writer) {
		try {
			Template temp = 
				getConfiguration().getTemplate("resourceFile.ftl");
			 
			temp.process(this, writer);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}  
	}
	
	/* (non-Javadoc)
	 * @see org.simantics.graph.resourceFiles.IResourceFile#getContent()
	 */
	@Override
	public InputStream getContent() {
		StringWriter writer = new StringWriter();
		write(new FilterCRWriter(writer));
		return new ByteArrayInputStream(writer.toString().getBytes(UTF8));
	}
	
	/* (non-Javadoc)
	 * @see org.simantics.graph.resourceFiles.IResourceFile#getFileName()
	 */
	@Override
	public String getFileName() {
		return "src/" + packageName.replace('.', '/') + "/" + className + ".java";
	}
	
	public void sort() {
		Collections.sort(resources);
	}
	
	public static void main(String[] args) {
		ResourceRef Foo = new ResourceRef("Foo", "http://www.dsf.sdf/Foo");
		ResourceRef Bar = new ResourceRef("Foo", "http://www.dsf.sdf/Bar");
		Bar.deprecated = true;
		new ResourceFile("org.simantics.graph", "Testi", Arrays.<ResourceRef>asList(
				Foo, Bar
			)).write(new OutputStreamWriter(System.out));
	}
}
