package org.simantics.graph.compiler.internal.resourceFiles;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class FilterCRWriter extends FilterWriter {

    public FilterCRWriter(Writer out) {
        super(out);
    }
    
    @Override
    public void write(int c) throws IOException {
        if(c != '\r')
            out.write(c);
    }
    
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int begin = 0;
        for(int i=0;i<len;++i) {
            if(cbuf[off+i] == '\r') {
                if(i > begin)
                    write(cbuf, off+begin, i-begin);
                begin = i+1;
            }
        }
        if(len > begin)
            write(cbuf, off+begin, len-begin);
    }
    
    @Override
    public void write(String str, int off, int len) throws IOException {
        int begin = 0;
        for(int i=0;i<len;++i) {
            if(str.charAt(off+i) == '\r') {
                if(i > begin)
                    write(str, off+begin, i-begin);
                begin = i+1;
            }
        }
        if(len > begin)
            write(str, off+begin, len-begin);
    }

}
