package org.simantics.graph.compiler.internal.procedures;

import org.simantics.graph.store.GraphStore;
import org.simantics.graph.store.IdentityStore;

public class PropagateNewMarks implements Runnable {
	IdentityStore identities;

	public PropagateNewMarks(GraphStore store) {
		this.identities = store.identities;
	}

	private void propagateNewMarks(int resource) {
		for(int child : identities.getChildren(resource))
			if(identities.markNew(child))
				propagateNewMarks(child);
	}
	
	@Override
	public void run() {
		for(int resource : identities.getNewResources())
			propagateNewMarks(resource);	
	}
}
