package org.simantics.graph.compiler.internal.procedures;

import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.set.hash.THashSet;

import java.util.Collection;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.graph.compiler.internal.store.LocationStore;
import org.simantics.graph.compiler.internal.templates.TemplateDefinition;
import org.simantics.graph.compiler.internal.templates.TemplateDefinitionStore;
import org.simantics.graph.query.CompositeGraph;
import org.simantics.graph.query.Paths;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.store.GraphStore;
import org.simantics.ltk.Location;
import org.simantics.ltk.Problem;

public class CreateTemplates implements Runnable {
	
	CompositeGraph graph;
	GraphStore store;
	Collection<Problem> problems;
	
	int HasTemplate;
	int HasTemplateParameters;
	int InstanceOf;
	int StringArray;
	int Graph;
	
	public CreateTemplates(CompositeGraph graph, GraphStore store,
			Collection<Problem> problems) {
		this.graph = graph;
		this.store = store;
		this.problems = problems;
	}

	@Override
	public void run() {
		TemplateDefinitionStore templateStore = store.getStore(TemplateDefinitionStore.class);
		if(templateStore == null || templateStore.isEmpty())
			return;
		
		Paths paths = graph.getPaths();
		HasTemplate = store.identities.createPathToId(paths.HasTemplate);
		HasTemplateParameters = store.identities.createPathToId(paths.HasTemplateParameters);
		InstanceOf = store.identities.createPathToId(paths.InstanceOf);
		StringArray = store.identities.createPathToId(paths.StringArray);
		Graph = store.identities.createPathToId(paths.Graph);
				
		templateStore.forTemplateDefinitions(
			new TIntObjectProcedure<TemplateDefinition>() {
				@Override
				public boolean execute(int templateId, TemplateDefinition template) {
					if(validateTemplate(templateId, template))
						writeTemplate(templateId, template);
					return true;
				}							
			});
	}	
	
	private boolean validateTemplate(int templateId, TemplateDefinition template) {
		THashSet<String> parameters = new THashSet<String>();
		parameters.add("");
		for(String parameter : template.getParameters())
			parameters.add(parameter);
		boolean isValid = true;
		GraphStore templateStore = template.getTemplate();
		for(String root : templateStore.identities.getRoots())
			if(!parameters.contains(root)) {
				LocationStore templateLocations = templateStore.getStore(LocationStore.class);
				Location location = templateLocations == null ? null
						: templateLocations.getLocation(templateStore.identities.getRoot(root));
				if(location == null) {
					LocationStore locations = store.getStore(LocationStore.class);
					location = locations == null ? null 
							: locations.getLocation(templateId);				
				}
				problems.add(new Problem(
						location, 
						"Graph template does not have parameter %" + root + "."
					));
				isValid = false;
			}
		return isValid;
	}	
	
	private void writeTemplate(int templateId,
			TemplateDefinition template) {
	    TransferableGraph1 tg = template.convert(graph, store, problems);

	    int templateValue = store.identities.newResource();
	    store.values.setValue(templateValue, new Variant(TransferableGraph1.BINDING, tg));
	    store.statements.add(templateId, HasTemplate, templateValue);
	    store.statements.add(templateValue, InstanceOf, Graph);

	    int parameters = store.identities.newResource();
	    store.values.setValue(parameters, 
	            new Variant(Bindings.STRING_ARRAY, template.getParameters()));
	    store.statements.add(templateId, HasTemplateParameters, parameters);
	    store.statements.add(parameters, InstanceOf, StringArray);
	}
}
