package org.simantics.graph.compiler.internal.procedures;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;

import java.util.Collection;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.graph.compiler.internal.store.PreValueStore;
import org.simantics.graph.query.IDataTypeQuery;
import org.simantics.graph.query.IGraph;
import org.simantics.graph.query.Paths;
import org.simantics.graph.store.GraphStore;
import org.simantics.graph.store.StatementStore;
import org.simantics.graph.store.ValueStore;
import org.simantics.ltk.Problem;

public class ConvertPreValues implements Runnable {

	IGraph cg;
	GraphStore store;
	Collection<Problem> problems;
	
	public ConvertPreValues(IGraph cg, GraphStore store,
			Collection<Problem> problems) {
		this.cg = cg;
		this.store = store;
		this.problems = problems;
	}

	@Override
	public void run() {
		PreValueStore preValues = store.getStore(PreValueStore.class);
		preValues.convertPreValues(store.values, new IDataTypeQuery() {	
			
		    Paths paths = cg.getPaths();
			StatementStore statements = store.statements;
			ValueStore values = store.values;
			int HasDatatype = store.identities.createPathToId(paths.HasDatatype);
			int InstanceOf = store.identities.createPathToId(paths.InstanceOf);
			
			@Override
			public Binding getDataType(int id) {
				TIntArrayList objects = statements.getObjects(id, HasDatatype);
				if(objects.isEmpty()) {
					objects = statements.getObjects(id, InstanceOf);
					for(int i=0;i<objects.size();++i) {
						int type = objects.getQuick(i);
						Binding binding = getDatatypeForType(type);
						if(binding != null)
							return binding;
					}
					return null;
				}
				else {
					Datatype dt = values.getDatatypeValue(objects.getQuick(0));
					if(dt == null)
						return null;
					else
						return Bindings.getBinding(dt);
				}				
			}

			TIntObjectHashMap<Binding> typeBindingCache = new TIntObjectHashMap<Binding>();
			private Binding getDatatypeForType(int type) {
				if(typeBindingCache.containsKey(type))
					return typeBindingCache.get(type);
				else {
					Datatype dt = cg.getAssertedDatatype(store.idToRes(type));
					Binding binding = dt == null ? null : Bindings.getBinding(dt);
					typeBindingCache.put(type, binding);
					return binding;
				}				
			}
		}, problems);
	}	

}
