package org.simantics.graph.compiler.internal.procedures;

import gnu.trove.map.hash.TIntIntHashMap;

import org.simantics.graph.store.GraphStore;

public class Compactify implements Runnable {
	GraphStore store;

	public Compactify(GraphStore store) {
		this.store = store;
	}

	@Override
	public void run() {
		// Mark all used resources
		int resourceCount = store.identities.getResourceCount();
		final boolean[] temp = new boolean[resourceCount];
		store.collectReferences(temp);
		
		// Create a map
		int newResourceCount = 0;
		TIntIntHashMap map = new TIntIntHashMap(resourceCount);
		for(int i=0;i<resourceCount;++i)
			if(temp[i])
				map.put(i, newResourceCount++);
		if(newResourceCount < resourceCount) {
			store.map(map);
			store.identities.setResourceCount(newResourceCount);
		}
	}
}
