/**
 * Contains simple <code>gnuplot</code> installation detection and
 * <code>gnuplot</code> execution facilities.
 * 
 * <p>
 * The installation detection logic relies purely on two environment variables.
 * Primarily the <code>GNUPLOT</code> variable and secondarily on
 * <code>PATH</code>. <code>GNUPLOT</code> can be set to point to one of the
 * following:
 * <ul>
 * <li>the full path to the gnuplot executable directly (including file name
 * suffix</li>
 * <li>the <code>bin</code> directory of a gnuplot installation</li>
 * <li>the root directory of a gnuplot installation</li>
 * </ul>
 * Secondarily the detection will check whether the <code>PATH</code> variable
 * contains any files system path that corresponds to a gnuplot installation
 * <code>bin</code> directory, i.e. the directory contains a
 * <code>gnuplot</code> excutable.
 * 
 * <p>
 * In both cases the detection will also ensure that the discovered gnuplot
 * executable responds to the <code>-V</code> (version) argument as expected,
 * i.e. returns a line starting with "gnuplot ".
 * 
 * @author Tuukka Lehtonen
 * @since 1.24
 */
package org.simantics.gnuplot;