package org.simantics.gnuplot;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

/**
 * @author Tuukka Lehtonen
 * @since 1.24
 */
class InputStreamToFileCopier implements Runnable {

    private final InputStream in;
    private final Path out;

    public InputStreamToFileCopier(InputStream in, Path out) {
        this.in = in;
        this.out = out;
    }

    @Override
    public void run() {
        try {
            if (out != null) {
                Files.copy(in, out, StandardCopyOption.REPLACE_EXISTING);
            } else {
                drain(in);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void drain(InputStream in) throws IOException {
        while (in.read() >= 0);
    }

}