package org.simantics.export.core.manager;

import java.util.ArrayList;
import java.util.List;

import org.simantics.export.core.ExportContext;

public class ExportPlan {

	public String label = "Export action";
	
	/** A list of actions */
	List<ExportAction> actions = new ArrayList<ExportAction>();
	
	/** Expected outcome */
	List<Content> manifest = new ArrayList<Content>(); 
	
	public void addAction(ExportAction action) {
		actions.add( action );
	}
	
	public void addToManifest(Content content) {
		manifest.add( content );
	}
	
	public int totalWork(ExportContext ctx) {
		int total = 0;
		for (ExportAction action : actions)
			total += action.work(ctx);
		return total;
	}
	
	public List<Content> getManifest() {
		return manifest;
	}

}
