package org.simantics.export.core.intf;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.export.core.error.ExportException;

/**
 * Description of a file format.
 *
 * @author toni.kalajainen@semantum.fi
 */
public interface Format extends FormatClass {
	
	/**
	 * Format identifier
	 * @return format identifier
	 */
	String id();
	
	/**
	 * File extension of this format
	 * @return
	 */
	String fileext();
	
	/**
	 * Defines the writer class that the exporter extension will use for writing the content of this format.
	 * @return
	 * @throws ClassNotFoundException 
	 */
	Class<?> writerClass() throws ClassNotFoundException;
	
	/**
	 * The class the importer will use for reading the associated content type.
	 * @return
	 * @throws ClassNotFoundException 
	 */
	Class<?> readerClass() throws ClassNotFoundException;
	
	/**
	 * Create action factory for the file format.
	 * 
	 * @return action factory
	 * @throws ExportException 
	 */
	FormatClass formatActions() throws ExportException;
	
	/**
	 * The label
	 * @return
	 */
	String label();
	
	/**
	 * The label in plural form
	 * @return
	 */
	String plural();
	
	/**
	 * Image descriptor
	 * @return
	 */
	ImageDescriptor icon();
	
	/**
	 * Set to true, if the format supports merging of multiple items of content of one type.
	 * @return true if this is group format
	 */
	boolean isGroupFormat();
	
	/**
	 * Set to true, if the format can contain multiple content items of any types.
	 * @return true if this is container format
	 */
	boolean isContainerFormat();
	
	/**
	 * This attribute determines if the format is attachable to another format of group type.
	 * 
	 * @return true if this is attachable format.
	 */
	boolean isAttachable();
	
	/**
	 * This property determines - if true - that the content must always be published and cannot be hidden inside container file.
	 * 
	 * @return if, true that the content must always be published and cannot be hidden inside container file.
	 */
	boolean isAlwaysPublished();
	
	/**
	 * If true, this format is can contain links to other files.
	 * @return true, this format is can contain links to other files.
	 */
	boolean isLinkContainer();
	
	/**
	 * The default selection for merge the group.
	 * @return
	 */
	boolean mergeGroupFormatDefault();
		
}
