package org.simantics.export.core.intf;

import org.simantics.export.core.error.ExportException;

/**
 * Exporter exports content for one specific format.
 *
 * @author toni.kalajainen@semantum.fi
 */
public interface Exporter {
	
	/**
	 * Identifier for the file format, eg. "pdf", "tg", "csv".
	 * @return
	 */
	String formatId();
	
	/**
	 * The identifier to the content type, that this definition can export.
	 * @return 
	 */
	String contentTypeId();
	
	/**
	 * Code that exports the content into format specific writer. 
	 * @return
	 * @throws ExportException 
	 */
	ExportClass exportAction() throws ExportException;
	
	/**
	 * Priority of this exporter in comparison to other exporters for the 
	 * content. The smaller the number the higher the priority. 
	 * 
	 * @return priority 
	 */
	int getExportPriority();
	
}
