package org.simantics.excel;

public class ExecEnvironment {

    public enum OSType {
        APPLE, LINUX, SUN, WINDOWS, UNKNOWN
    }
    
    public enum ARCHType {
        PPC, PPC_64, SPARC, X86, X86_64, UNKNOWN;
    }
    
    public final OSType os;
    public final ARCHType arch;

    private ExecEnvironment(OSType os, ARCHType arch) {
        this.os = os;
        this.arch = arch;
    }

    public static ExecEnvironment calculate() {
        return new ExecEnvironment(calculateOS(), calculateArch());
    }

    public static ARCHType calculateArch() {
        String osArch = System.getProperty("os.arch", "");
        osArch = osArch.toLowerCase();
        if (osArch.equals("i386") || osArch.equals("i586") || osArch.equals("i686") || osArch.equals("x86"))
            return ARCHType.X86;
        if (osArch.startsWith("amd64") || osArch.startsWith("x86_64"))
            return ARCHType.X86_64;
        if (osArch.equals("ppc"))
            return ARCHType.PPC;
        if (osArch.startsWith("ppc"))
            return ARCHType.PPC_64;
        if (osArch.startsWith("sparc"))
            return ARCHType.SPARC;
        return ARCHType.UNKNOWN;
    }

    public static OSType calculateOS() {
        String osName = System.getProperty("os.name", "");
        osName = osName.toLowerCase();
        if (osName.startsWith("mac os x"))
            return OSType.APPLE;
        if (osName.startsWith("windows"))
            return OSType.WINDOWS;
        if (osName.startsWith("linux"))
            return OSType.LINUX;
        if (osName.startsWith("sun"))
            return OSType.SUN;
        return OSType.UNKNOWN;
    }
}
