package org.simantics.event.view.handler;

import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ErrorLogger;

/**
 * @author Tuukka Lehtonen
 */
public class DenyAction extends Action {

    private final String virtualGraphId;
    private final List<Resource> subjects;
    private final String relationURI;

    /**
     * @param label
     * @param image
     * @param virtualGraphId
     * @param tagURI
     * @param tag <code>true</code> to add tag, <code>false</code> to remove tag
     * @param input
     */
    public DenyAction(String label, ImageDescriptor image, String virtualGraphId, String relationURI, List<Resource> subjects) {
        super(label, image);

        this.virtualGraphId = virtualGraphId;
        this.subjects = subjects;
        this.relationURI = relationURI;
    }

    @Override
    public void run() {
        Session session = Simantics.peekSession();
        if (session != null) {
            VirtualGraph vg = virtualGraphId == null ? null :
                session.getService(VirtualGraphSupport.class).getWorkspacePersistent(virtualGraphId);
            session.asyncRequest(new WriteRequest(vg) {
                @Override
                public void perform(WriteGraph graph) throws DatabaseException {
                    Resource relation = graph.getResource(relationURI);
                    for (Resource subject : subjects)
                        graph.deny(subject, relation);
                }
            }, new Callback<DatabaseException>() {
                @Override
                public void run(DatabaseException parameter) {
                    if (parameter != null)
                        ErrorLogger.defaultLogError(parameter);
                }
            });
        }
    }

}
