/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.editors.win32.ole;

import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;

/**
 * Windows Media Player
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class WMP_Definition implements EditorDefinition{
	
	static String[] suffix = new String[]{"wav","wma","wmv","asf","mp3","mpg","avi"};
	
	@Override
	public OleController createController(OleFrame frame, OleClientSite site,
			OleAutomation auto) {
		return new WMPController(frame,site,auto);
	}
	
	@Override
	public String getProgID() {
		return "WMPlayer.OCX";
	}
	
	@Override
	public boolean supportSuffix(String suffix) {
		for (String s: WMP_Definition.suffix) {
			if (suffix.equals(s))
				return true;
		}
		return false;
	}
	
	@Override
	public boolean useBrowser() {
		return false;
	}
	
	@Override
	public boolean useFileInput() {
		return false;
	}
	

}
