/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.editors.win32.ole;

import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.simantics.editors.win32.OLEEditorInput;


/**
 * Windows Media Player utility.
 * 
 * Note: there is a bug with WMP11: it launches WMP website when the control is activated.
 * 
 * @see http://dev.eclipse.org/newslists/news.eclipse.platform.swt/msg20193.html
 * 
 * @author MLMARKO
 *
 */
public class WMPController implements OleController {
	
	OleFrame frame;
	OleClientSite site;
	OleAutomation auto;
	
	public WMPController(OleFrame frame, OleClientSite site, OleAutomation auto) {
		this.frame = frame;
		this.site = site;
		this.auto = auto;
	}
	
	public void show(OLEEditorInput input) {
		site.doVerb(OLE.OLEIVERB_SHOW);
		// size must be 240x245 and uiMode full to correctly align the player component with the editor
		frame.setSize(240, 245);
		// WMP11 won't show video, if uimode is not set to none when URL is set
		setUIMode("none");
        setStrechToFit(true);
        
        String url = "file:///"+ input.getFile().getAbsoluteFile();
		url = url.replace('\\', '/');
		System.out.println(url);
		loadMedia(url);
        
		frame.layout();
		// URL has been set, so we can set uimode to full
		setUIMode("full");
	}
	
	public void setUIMode(String mode) {
		int ids[] = auto.getIDsOfNames(new String[] { "uiMode" });
        if (ids != null) {
            auto.setProperty(ids[0], new Variant(mode)); //"none","full"
        }
	}
	
	public void setStrechToFit(boolean fit) {
		int ids[] = auto.getIDsOfNames(new String[] { "stretchToFit" });
        if (ids != null) {
            auto.setProperty(ids[0], new Variant(fit));
        }
	}
	
	public void loadMedia(String url) {
		int[] rgdispid;
		rgdispid = auto.getIDsOfNames(new String[]{"URL"});
		if (rgdispid != null) {
			int dispIdMember = rgdispid[0];
			
			boolean b = auto.setProperty(dispIdMember, new Variant(url));
			System.out.println(b);
		}	
	}
	
	public void play() {
		int[] rgdispid = auto.getIDsOfNames(new String[] { "controls" }); //$NON-NLS-1$
		Variant pVarResult = auto.getProperty(rgdispid[0]);
		if (pVarResult == null || pVarResult.getType() == 0)
			return;
		OleAutomation controls = pVarResult.getAutomation();
		rgdispid = controls.getIDsOfNames(new String[] { "play" }); //$NON-NLS-1$
		controls.invoke(rgdispid[0]);
		pVarResult.dispose();
		controls.dispose();
	}
	
	public void stop() {
		int[] rgdispid = auto.getIDsOfNames(new String[] { "controls" }); //$NON-NLS-1$
		Variant pVarResult = auto.getProperty(rgdispid[0]);
		if (pVarResult == null || pVarResult.getType() == 0) return;
		OleAutomation controls = pVarResult.getAutomation();
		rgdispid = controls.getIDsOfNames(new String[]{ "stop" }); //$NON-NLS-1$
		controls.invoke(rgdispid[0]);
		pVarResult.dispose();
		controls.dispose();
    }
	
	public boolean setFullScreen(boolean mode) {
		int[] rgdispid = auto.getIDsOfNames(new String[] { "fullScreen" }); //$NON-NLS-1$
		boolean result = auto.setProperty(rgdispid[0], new Variant(mode));
		return result;
	}
	
	public boolean setWindowlessVideo(boolean mode) {
		int[] rgdispid = auto.getIDsOfNames(new String[] { "windowlessVideo" }); //$NON-NLS-1$
		boolean result = auto.setProperty(rgdispid[0], new Variant(mode));
		return result;
	}
	
	public String getStatus() {
		int[] rgdispid = auto.getIDsOfNames(new String[] { "status" }); //$NON-NLS-1$
		Variant pVarResult = auto.getProperty(rgdispid[0]);
		if (pVarResult == null || pVarResult.getType() != OLE.VT_BSTR)
			return "";
		String result = pVarResult.getString();
		pVarResult.dispose();
		return result;
	}

}
