/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.editors.win32.ole;

import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;

/**
 * Embedding for Windows Picture and Fax Preview
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class PreviewDefinition implements EditorDefinition{
	
	@Override
	public OleController createController(OleFrame frame, OleClientSite site,
			OleAutomation auto) {
		return new PreviewController(frame,site,auto);
	}
	
	@Override
	public String getProgID() {
		return "Preview.Preview";
	}
	
	@Override
	public boolean supportSuffix(String suffix) {
		if (suffix.equals("png"))
			return true;
		if (suffix.equals("jpg"))
			return true;
		if (suffix.equals("bmp"))
			return true;
		return false;
	}
	
	@Override
	public boolean useBrowser() {
		return false;
	}
	
	@Override
	public boolean useFileInput() {
		return false;
	}

}
