/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.editors.win32.ole;

import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.simantics.editors.win32.OLEEditorInput;


/**
 * Utility for Windows Picture and Fax Preview
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class PreviewController implements OleController {

	OleFrame frame;
	OleClientSite site;
	OleAutomation auto;
	
	public PreviewController(OleFrame frame, OleClientSite site, OleAutomation auto) {
		this.frame = frame;
		this.site = site;
		this.auto = auto;
	}
	
	public void show(OLEEditorInput input) {
		site.doVerb(OLE.OLEIVERB_SHOW);
		loadFile(input.getFile().getAbsoluteFile().toString());
	}
	
	public void loadFile(String file) {
		
		int[] rgdispid;
		rgdispid = auto.getIDsOfNames(new String[]{"Show"});
		
		if (rgdispid != null) {
			int dispIdMember = rgdispid[0];
			auto.invoke(dispIdMember, new Variant[]{new Variant(file)});
		}	
	}
	
	public void bestFit() {
		int[] rgdispid;
		rgdispid = auto.getIDsOfNames(new String[]{"BestFit"});
		
		if (rgdispid != null) {
			int dispIdMember = rgdispid[0];
			auto.invoke(dispIdMember);
		}
	}
	
	public void actualSize() {
		int[] rgdispid;
		rgdispid = auto.getIDsOfNames(new String[]{"ActualSize"});
		
		if (rgdispid != null) {
			int dispIdMember = rgdispid[0];
			auto.invoke(dispIdMember);
		}
	}
	
	public void zoom(int i) {
		
		int[] rgdispid;
		rgdispid = auto.getIDsOfNames(new String[]{"Zoom"});
		
		if (rgdispid != null) {
			int dispIdMember = rgdispid[0];
			auto.invoke(dispIdMember, new Variant[]{new Variant(i)});
		}	
	}
	

}
