/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.editors.win32.ole;

import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;

/**
 * ControllerFactory for embedding OLE editors into eclipse
 * There are three different methods to integrate editors to eclipse
 * 1. Use browser integration
 * 2. Use OLE's automatic resolver
 * 3. Using progID to get ActiveX control, and managing that control by self supplied code.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public interface EditorDefinition {
	
	public boolean supportSuffix(String suffix);
	
	/**
	 * Use embedded browser to show the input
	 * @return
	 */
	public boolean useBrowser();
	
	/**
	 * Use OLE's automatic resolver for embedding
	 * @return
	 */
	public boolean useFileInput();
	
	/**
	 * Returns ActiveX component's progID
	 * @return
	 */
	public String getProgID();
	
	public OleController createController(OleFrame frame, OleClientSite site, OleAutomation auto);

}
