/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.editors.win32;

import java.io.File;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.simantics.editors.win32.ole.EditorDefinition;

/**
 * EditorInput for the OLEEditor component.
 * Input can be configured in two ways: 
 * 
 * 1) giving an input file and the system tries to find proper ActiveX component for it.
 * 2) giving both input file, and ActiveX component's progID.
 * 
 * @author Marko Luukkainen <Marko.Luukkainen@vtt.fi>
 *
 */
public class OLEEditorInput implements IEditorInput {
	
	private String name;
	private EditorDefinition factory;
	private File file;
	private boolean fullscreen;
	
	public OLEEditorInput(EditorDefinition factory, File file) {
		this(factory,file,false);
	}
	
	public OLEEditorInput(EditorDefinition factory, File file, boolean fullscreen) {
		this(factory,file,file.getName(),fullscreen);
	}
	
	public OLEEditorInput(EditorDefinition factory, File file, String name, boolean fullscreen) {
		if (file == null || factory == null || name == null)
			throw new NullPointerException();
		this.file = file;
		this.factory = factory;
		this.fullscreen = fullscreen;
		this.name = name;
	}
	

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return null;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName();
	}

	@SuppressWarnings({ "rawtypes" })
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public File getFile() {
		return file;
	}
	
	public EditorDefinition getFactory() {
		return factory;
	}
	
	public boolean isFullscreen() {
		return fullscreen;
	}
	
	@Override
	public boolean equals(Object arg0) {
		if (arg0 == null)
			return false;
		if (arg0.getClass() != getClass())
			return false;
		OLEEditorInput other = (OLEEditorInput)arg0;
		return other.file.equals(file);
					
	}
	
	@Override
	public int hashCode() {
		return file.hashCode();
	}

	

}
