/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.editors.win32;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.simantics.editors.win32.ole.EditorDefinition;
import org.simantics.editors.win32.ole.OleController;


/**
 * OLEEditor is a wrapper for Windows ActiveX components.
 * 
 * @author Marko Luukkainen <Marko.Luukkainen@vtt.fi>
 *
 */
public class OLEEditor extends EditorPart {

	private OleFrame frame;
	private OleClientSite site;
	private OleAutomation auto;
	private OleController ctrl;
	
	private Shell fsShell;
	
	public OLEEditor() {
		super();
	}

	@Override
	public void doSave(IProgressMonitor monitor) {

	}

	@Override
	public void doSaveAs() {

	}

	@Override
	public void init(IEditorSite site, IEditorInput input)
			throws PartInitException {
		if (!(input instanceof OLEEditorInput))
			throw new PartInitException("Input must be OLEEditorInput");
		setInput(input);
		setSite(site);

	}

	@Override
	public boolean isDirty() {
		return false;
	}

	@Override
	public boolean isSaveAsAllowed() {
		return false;
	}
	

	@Override
	public void createPartControl(Composite parent) {
		OLEEditorInput input = (OLEEditorInput)getEditorInput();
		boolean fullscreen = input.isFullscreen();
		if (fullscreen) {
			fsShell = new Shell(parent.getDisplay());
			
			fsShell.setLayout(new GridLayout(1,false));
			fsShell.setLayout(new FillLayout());
			parent = new Composite(fsShell,SWT.NONE);
			fsShell.open();
			fsShell.setFullScreen(true);
			parent.setLayout(new FillLayout());
		}
		
		
		EditorDefinition factory = input.getFactory();
		frame = new OleFrame(parent, SWT.NONE);
		
		if (factory.getProgID() == null || factory.useFileInput()) {
			site = new OleClientSite(frame,SWT.NONE,input.getFile());
		} else {
			site = new OleClientSite(frame, SWT.NONE, factory.getProgID());
			auto = new OleAutomation(site);
			ctrl = factory.createController(frame, site, auto);
			ctrl.show(input);
		}
		
		setPartName(site.getProgramID() + " : " + input.getName());
		
		if (fullscreen) {
			fsShell.layout(true, true);
		}
	}

	@Override
	public void setFocus() {
		frame.setFocus();
	}
	
	/**
	 * Returns OleController of embedded OLE component. May return null.
	 * @return
	 */
	public OleController getController() {
		return ctrl;
	}
	
	@Override
	public void dispose() {
		if (auto != null)
			auto.dispose();
		site.dispose();
		if (fsShell != null)
			fsShell.dispose();
		if (frame != null) {
			frame.dispose();
		}
		super.dispose();

	}

}
