/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.editors.win32;

import java.io.File;
import java.net.URL;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.simantics.editors.BrowserInput;
import org.simantics.editors.internal.SystemFile;
import org.simantics.editors.win32.ole.EditorDefinition;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.WorkbenchUtils;



public class Editors {

	@Deprecated
	/**
	 * Opens extenal application for a file.
	 * 
	 * Deprecated: Since the functionality is not Windows specific feature, this method has been moved to org.simantics.editors.Editors class.
	 * @param file
	 * @return
	 * @throws PartInitException
	 */
	public static IEditorPart openExternalEditor(File file) throws PartInitException {
		IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor(IEditorRegistry.SYSTEM_EXTERNAL_EDITOR_ID);
		IWorkspace ws = (IWorkspace) ResourcesPlugin.getWorkspace();
		FileEditorInput input = new ExternalFileEditorInput(new SystemFile(file, ws));
		IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		IWorkbenchPage page = window.getActivePage();
		return page.openEditor(input, desc.getId());
		
	}
	
	private static class ExternalFileEditorInput extends FileEditorInput {

		public ExternalFileEditorInput(IFile file) {
			super(file);
		}
		
		@Override
		public void saveState(IMemento memento) {
			
		}
		
	}
	
	public static IEditorPart openEmbeddedEditor(File file) {
		return openEmbeddedEditor(file,false);
	}
	
	public static boolean isSupported(String filename) {
		String suffix = "";
		int index = filename.lastIndexOf(".");
		if (index != -1)
			suffix = filename.substring(index+1).toLowerCase();
		else
			suffix = filename.toLowerCase();
		EditorDefinition factory = EditorDefinitionManager.getInstance().getFactoryForSuffix(suffix);
		return factory != null;
	}
	
	public static IEditorPart openEmbeddedEditor(File file, boolean fullscreen) {
		return openEmbeddedEditor(file, file.getName(), fullscreen);
	}
	public static IEditorPart openEmbeddedEditor(File file, String title, boolean fullscreen) {
		String filename = file.getAbsoluteFile().toString();
		String suffix = "";
		int index = filename.lastIndexOf(".");
		if (index != -1)
			suffix = filename.substring(index+1).toLowerCase();
		else
			suffix = filename.toLowerCase();
		
		
		
		try {
			EditorDefinition factory = EditorDefinitionManager.getInstance().getFactoryForSuffix(suffix);
			if (factory == null) {
				throw new RuntimeException("Cannot find editorDefinition for " + suffix);
			}
			

			if (!factory.useBrowser()) {
				OLEEditorInput input = new OLEEditorInput(factory, file, title, fullscreen);
				return WorkbenchUtils.openEditor("org.simantics.editors.win32.oleeditor", input);
			}
			URL url = file.toURI().toURL();
			BrowserInput input = new BrowserInput(url,false, fullscreen);
			input.setName(title);
			return WorkbenchUtils.openEditor("org.simantics.editors.browser", input);
		
		} catch (Exception e) {
			ErrorLogger.defaultLogError("Cannot use internal editor, trying external editor", e);
		}

		//ErrorLogger.defaultLogError("Cannot embed ActiveX contol, using external application.", null);
		try {
			// show the file contents in external editor / application
			return org.simantics.editors.Editors.openExternalEditor(file);
		} catch (Exception err) {
			ErrorLogger.defaultLogError(err);
		}
		return null;
	}
	
//	public static void openEmbeddedEditor(URL url) {
//		
//		
//	}
}
