package org.simantics.document.swt.core.widget;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.Column.Align;
import org.simantics.browsing.ui.StatePersistor;
import org.simantics.browsing.ui.swt.InputSourceImpl;
import org.simantics.browsing.ui.swt.widgets.DragSourceListenerFactory;
import org.simantics.browsing.ui.swt.widgets.ModelBrowser;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.db.layer0.variable.VariableBean;
import org.simantics.db.management.ISessionContext;
import org.simantics.document.server.JSONObject;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.SWTViews;
import org.simantics.document.swt.core.base.LeafWidgetManager;
import org.simantics.document.swt.core.base.WidgetContainer;
import org.simantics.document.swt.core.bean.ColumnBean;
import org.simantics.document.swt.core.bean.ColumnsBean;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.ui.selection.WorkbenchSelectionUtils;

public class Explorer extends LeafWidgetManager<ModelBrowser> {

	@Override
	protected void doUpdateProperties(SWTDocument document, ModelBrowser control, JSONObject object) {
		//			String text = object.getField("text");
		//			control.setText(text);
	}

	protected Column[] getColumns(ColumnsBean bean) {
		Column[] result = new Column[bean.columns.length];
		for(int i=0;i<bean.columns.length;i++) {
			ColumnBean cb = bean.columns[i];
			result[i] = new Column(cb.key, cb.label, Align.valueOf(cb.alignment), cb.width, cb.tooltip, cb.grab, cb.weight);
		}
		return result;
	}
	
	@Override
	protected ModelBrowser doCreateControl(SWTDocument document, Composite parent, JSONObject object) {
		
		String browseContext = object.getJSONField("browseContext");
		if(browseContext == null) return null;

		String contextMenuId = object.getJSONField("contextMenuId");
		
		Boolean displayFilter = object.getJSONField("displayFilter");
		Boolean displayHeader = object.getJSONField("displayHeader");
		Integer style = object.getJSONField("style");
		if(style == null) style = SWT.FULL_SELECTION;
		
        Boolean vscroll = object.getJSONFieldDefault("VScroll", false);
        if(Boolean.TRUE.equals(vscroll))
            style |= SWT.V_SCROLL;
        
        Boolean hscroll = object.getJSONFieldDefault("HScroll", false);
        if(Boolean.TRUE.equals(hscroll))
            style |= SWT.H_SCROLL;

        Boolean noscroll = object.getJSONFieldDefault("NoScroll", false);
        if(Boolean.TRUE.equals(noscroll))
            style |= SWT.NO_SCROLL;
		
		StatePersistor persistor = object.getJSONField("persistor");
		final Function1<Object, Boolean> selectionListener = object.getJSONField("selectionListener");

		DragSourceListenerFactory dragSourceListenerFactory = object.getJSONField("dragSourceListenerFactory");
		
		final IWorkbenchSite site = document.getSite();
		final ISelectionProvider selectionProvider = document.getSelectionProvider();

		Map<String, Object> args = new HashMap<String, Object>();
		args.put("displaySelectors", Boolean.FALSE);
		args.put("displayFilter", displayFilter != null ? displayFilter : Boolean.FALSE);

//		GridLayoutFactory.fillDefaults().applyTo(parent);

		ColumnsBean columns = object.getBeanJSONFieldDefault("columns", ColumnsBean.BINDING, null);
		String editingColumn = object.getJSONFieldDefault("editingColumn", null);
		
//		Column[] COLUMNS = new Column[] {
//				new Column("HasDisplayProperty", "Parameter description", Align.LEFT, 80, "Input parameter name", true),
//				new Column("HasDisplayValue", "Value", Align.RIGHT, 65, "Value"),
//				new Column("HasDisplayUnit", "Unit", Align.RIGHT, 100, "Unit") 
//		};
		
//		parent.setBackground(parent.getDisplay().getSystemColor(SWT.COLOR_RED));
		
		final ModelBrowser control = new ModelBrowser(Collections.singleton(browseContext), args, site, parent, new WidgetSupportImpl(), style);

		Tree tree = control.getExplorerControl();
		tree.addListener(SWT.SetData, new Listener() {
			
			@Override
			public void handleEvent(Event event) {
				SWTViews.notifyScrolledComposite(control);
			}
			
		});
		
		if(columns != null)
			control.setColumns(getColumns(columns));
		if(editingColumn != null)
			control.setEditingColumn(editingColumn);
		if(contextMenuId != null)
			control.setContextMenuId(contextMenuId);
		if(dragSourceListenerFactory != null)
			control.setDragSourceListenerFactory(dragSourceListenerFactory);
		if(displayHeader != null)
			tree.setHeaderVisible(displayHeader);
		
		control.setStatePersistor(persistor);

		control.finish();
		
		control.setInputSource(new InputSourceImpl<Object>() {

			@Override
			public Object get(ISessionContext ctx, Object selection) {
				return selection;
			}

		});
		
		// TODO: fixme!
		Object i = object.getJSONField("explorerInput");
		if(i instanceof VariableBean) {
			control.setInput(Simantics.getSessionContext(), ((VariableBean)i).getVariable());
		} else {
			control.setInput(Simantics.getSessionContext(), i);
		}
		
		control.addListenerToControl(SWT.Selection, new Listener() {

			@Override
			public void handleEvent(Event event) {

				if(selectionListener != null)
					selectionListener.apply(event);
				
				ISelection selection = (ISelection)control.getExplorer().getWidgetSelection();
				
				// TODO: refactor this!

				if(selectionProvider != null) {
					selectionProvider.setSelection(selection);
				}
				
//				if (site != null) {
//					ISelectionProvider sp = site.getSelectionProvider();
//					if (sp != null) {
//						sp.setSelection(selection);
//					}
//				}

			}

		});	

		return control;

	}
	
	@Override
	public String getProperty(SWTDocument document, JSONObject object, WidgetContainer<ModelBrowser> widget, String property) {
	    if("selection".equals(property)) {
            ISelection selection = (ISelection)widget.getControl().getExplorer().getWidgetSelection();
            return SWTViews.encode(object, property, WorkbenchSelectionUtils.getWorkbenchSelectionElements(selection));
	    }
	    return null;
	}

}
