package org.simantics.document.swt.core.widget;

import java.util.ArrayList;
import java.util.LinkedHashMap;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.simantics.document.server.IEventCommand;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.swt.core.SWTDocument;

public class ButtonSelectionListener implements SelectionListener {
    
    private LinkedHashMap<WidgetData, String> data;
    
    public ButtonSelectionListener(LinkedHashMap<WidgetData, String> data) {
        this.data = data;
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        widgetDefaultSelected(e);
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        SWTDocument document = null;
        // Build a linked list of commands
        ArrayList<IEventCommand> commands = new ArrayList<IEventCommand>();
        for(WidgetData d : data.keySet()) {
            document = (SWTDocument)d.document; // assume that all widgets are from the same document
            IEventCommand p = d.eventCommand(data.get(d));
            if(p != null) {
                if(!commands.isEmpty())
                    commands.get(commands.size()-1).setNext(p);
                commands.add(p);
            }
        }

        // empty errors
//        if(document != null)
//            document.displayError("");

        // Execute the first command, the linked list handles the rest of them
        if(!commands.isEmpty())
            commands.get(0).handleCommand();
    
    }
    
}