package org.simantics.document.swt.core.scl;

import java.util.List;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.document.server.handler.EventHandler;
import org.simantics.document.server.handler.WriteEventHandler;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandResult;
import org.simantics.document.server.serverResponse.ServerResponse;
import org.simantics.document.swt.core.SWTViews;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.ui.selection.WorkbenchSelectionUtils;

public class SCL {
    
    public static final String SCL_VALUE_PROPERTY = "sclValueProperty";
    
    public static EventHandler eventHandler(final Function1<Object, Object> fn) {
    	return new EventHandler() {
			
			@Override
			protected ServerResponse handle(ReadGraph graph, CommandContext parameters) throws DatabaseException {

			    final SCLReportingHandler printer = (SCLReportingHandler)SCLContext.getCurrent().get(SCLReportingHandler.REPORTING_HANDLER); 
				graph.async(new WriteRequest() {
					
					@Override
					public void perform(WriteGraph graph) throws DatabaseException {
					    SCLContext sclContext = SCLContext.getCurrent();
					    Object oldPrinter = sclContext.put(SCLReportingHandler.REPORTING_HANDLER, printer);
						Object oldGraph = sclContext.put("graph", graph);
						fn.apply(Tuple0.INSTANCE);
						sclContext.put(SCLReportingHandler.REPORTING_HANDLER, oldPrinter);
						sclContext.put("graph", oldGraph);
					}
					
				});
				
				return null;
				
			}
			
		};
    }
    
    public static String getURI(ReadGraph graph, Variable variable) throws DatabaseException {
        return variable.getURI(graph);
    }
    
    public static String propertyDisplayValue(ReadGraph graph, Variable variable, String property) throws DatabaseException {
        Variable var = variable.getProperty(graph, property);
        Variable var2 = var.getProperty(graph, Variables.DISPLAY_VALUE);
        return var2.getValue(graph);
    }
    
    public static AbstractEventHandler propertyValueSetter(ReadGraph graph, Variable variable, String property) throws DatabaseException {
        String uri = variable.getURI(graph);
        return new ValueSetter(uri, property);
    }
    
    public static String propertyGetter(ReadGraph graph, Variable variable) throws DatabaseException {
        String value = variable.getPossiblePropertyValue(graph, SCL_VALUE_PROPERTY);
        return value;
    }
    
    static class ValueSetter extends WriteEventHandler {
        
        private String varUri;
        private String property;
        
        public ValueSetter(String varUri, String property) {
            this.varUri = varUri;
            this.property = property;
        }
        
        @Override
        protected CommandResult handle(WriteGraph graph, CommandContext parameters) throws DatabaseException {
            Variable variable = Variables.getVariable(graph, varUri);
            Variable var = variable.getPossibleProperty(graph, property);
            Variable var2 = var.getPossibleProperty(graph, Variables.DISPLAY_VALUE);
            var2.setValue(graph, parameters.getString("text"), Bindings.STRING);
            return null;
        }
    };

    @SuppressWarnings("unchecked")
    public static List<WorkbenchSelectionElement> decodeWSES(String key) {
        return (List<WorkbenchSelectionElement>)SWTViews.decode(key);
    }
    
    public static Resource wseResource(ReadGraph graph, WorkbenchSelectionElement wse) throws DatabaseException {
        return WorkbenchSelectionUtils.getPossibleResource(wse);
    }

}
