package org.simantics.document.swt.core;

import java.util.Collections;
import java.util.Map;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.document.server.client.Document;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.document.server.io.CommandContext;

public interface SWTDocument extends Document {

    public static final Map<String,String> NO_PARAMETERS = Collections.emptyMap();
    
    IWorkbenchSite getSite();
	ISelectionProvider getSelectionProvider();
	Color getColor(org.simantics.datatypes.literal.RGB.Integer bean);
	Font getFont(org.simantics.datatypes.literal.Font bean);
	void post(AbstractEventHandler handler, CommandContext parameters);
	void layout();
	
    void displayError(String error);
	
}
