package org.simantics.document;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class DocumentResource {
    
    public final Resource Document;
    public final Resource DocumentLibrary;
    public final Resource DocumentSettings;
    public final Resource DocumentSettings_n$marginBottom;
    public final Resource DocumentSettings_n$marginBottom_Inverse;
    public final Resource DocumentSettings_n$marginLeft;
    public final Resource DocumentSettings_n$marginLeft_Inverse;
    public final Resource DocumentSettings_n$marginRight;
    public final Resource DocumentSettings_n$marginRight_Inverse;
    public final Resource DocumentSettings_n$marginTop;
    public final Resource DocumentSettings_n$marginTop_Inverse;
    public final Resource DocumentTemplate;
    public final Resource DocumentTypeBinding;
    public final Resource DocumentTypeBinding_HasDocumentType;
    public final Resource DocumentTypeBinding_HasDocumentType_Inverse;
    public final Resource DocumentTypeBinding_HasType;
    public final Resource DocumentTypeBinding_HasType_Inverse;
    public final Resource DocumentTypeBinding_priority;
    public final Resource DocumentTypeBinding_priority_Inverse;
    public final Resource FileDocument;
    public final Resource Functions;
    public final Resource Functions_documentationRootVariable;
    public final Resource Functions_documentationText;
    public final Resource Functions_standardEditText;
    public final Resource HasDocument;
    public final Resource HasDocumentTemplate;
    public final Resource HasDocumentTemplate_Inverse;
    public final Resource HasDocument_Inverse;
    public final Resource HasDocumentation;
    public final Resource HasDocumentation_Inverse;
    public final Resource HasLibraryRelation;
    public final Resource HasNewerVersion;
    public final Resource HasOlderVersion;
    public final Resource HasReportFactory;
    public final Resource HasReportFactory_Inverse;
    public final Resource HasUrl;
    public final Resource HasUrl_Inverse;
    public final Resource HasVersionType;
    public final Resource PlainTextDocument;
    public final Resource PlainTextDocument_text;
    public final Resource PlainTextDocument_text_Inverse;
    public final Resource PlainTextFileDocument;
    public final Resource PlainTextFileDocument_FilePath;
    public final Resource PlainTextFileDocument_filePath;
    public final Resource PlainTextFileDocument_filePath_Inverse;
    @Deprecated public final Resource Report;
    public final Resource Scenegraph;
    public final Resource ScenegraphDocument;
    public final Resource ScenegraphDocument_scenegraph;
    public final Resource ScenegraphDocument_scenegraph_Inverse;
    public final Resource Scenegraph_CategoryHidden;
    public final Resource Scenegraph_Composite;
    public final Resource Scenegraph_Diagram;
    public final Resource Scenegraph_Diagram_path;
    public final Resource Scenegraph_Diagram_path_Inverse;
    public final Resource Scenegraph_Node;
    public final Resource Scenegraph_Node_editText;
    public final Resource Scenegraph_Node_editText_Inverse;
    public final Resource Scenegraph_Node_printInPDF;
    public final Resource Scenegraph_Node_printInPDF_Inverse;
    public final Resource Scenegraph_ParameterType;
    public final Resource Scenegraph_Wiki;
    public final Resource Scenegraph_Wiki_text;
    public final Resource Scenegraph_Wiki_text_Inverse;
    public final Resource UrlDocument;
    public final Resource WikiDocument;
    public final Resource WikiDocument_WikiDocumentBinding;
    public final Resource WikiDocument_WikiDocumentTemplate;
    public final Resource WikiDocument_WikiDocumentTemplate_Header;
    public final Resource WikiDocument_WikiDocumentTemplate_User;
    public final Resource WikiDocument_WikiDocumentTemplate_UserDocumentation;
    public final Resource WikiDocument_WikiDocumentTemplate_UserDocumentation_Inverse;
    public final Resource WikiDocument_WikiText;
    public final Resource WikiDocument_wikiText;
    public final Resource WikiDocument_wikiText_Inverse;
    public final Resource cssDocument;
    public final Resource cssDocument_Inverse;
    public final Resource documentSettings;
    public final Resource documentSettings_Inverse;
        
    public static class URIs {
        public static final String Document = "http://www.simantics.org/Document-1.2/Document";
        public static final String DocumentLibrary = "http://www.simantics.org/Document-1.2/DocumentLibrary";
        public static final String DocumentSettings = "http://www.simantics.org/Document-1.2/DocumentSettings";
        public static final String DocumentSettings_n$marginBottom = "http://www.simantics.org/Document-1.2/DocumentSettings/n-marginBottom";
        public static final String DocumentSettings_n$marginBottom_Inverse = "http://www.simantics.org/Document-1.2/DocumentSettings/n-marginBottom/Inverse";
        public static final String DocumentSettings_n$marginLeft = "http://www.simantics.org/Document-1.2/DocumentSettings/n-marginLeft";
        public static final String DocumentSettings_n$marginLeft_Inverse = "http://www.simantics.org/Document-1.2/DocumentSettings/n-marginLeft/Inverse";
        public static final String DocumentSettings_n$marginRight = "http://www.simantics.org/Document-1.2/DocumentSettings/n-marginRight";
        public static final String DocumentSettings_n$marginRight_Inverse = "http://www.simantics.org/Document-1.2/DocumentSettings/n-marginRight/Inverse";
        public static final String DocumentSettings_n$marginTop = "http://www.simantics.org/Document-1.2/DocumentSettings/n-marginTop";
        public static final String DocumentSettings_n$marginTop_Inverse = "http://www.simantics.org/Document-1.2/DocumentSettings/n-marginTop/Inverse";
        public static final String DocumentTemplate = "http://www.simantics.org/Document-1.2/DocumentTemplate";
        public static final String DocumentTypeBinding = "http://www.simantics.org/Document-1.2/DocumentTypeBinding";
        public static final String DocumentTypeBinding_HasDocumentType = "http://www.simantics.org/Document-1.2/DocumentTypeBinding/HasDocumentType";
        public static final String DocumentTypeBinding_HasDocumentType_Inverse = "http://www.simantics.org/Document-1.2/DocumentTypeBinding/HasDocumentType/Inverse";
        public static final String DocumentTypeBinding_HasType = "http://www.simantics.org/Document-1.2/DocumentTypeBinding/HasType";
        public static final String DocumentTypeBinding_HasType_Inverse = "http://www.simantics.org/Document-1.2/DocumentTypeBinding/HasType/Inverse";
        public static final String DocumentTypeBinding_priority = "http://www.simantics.org/Document-1.2/DocumentTypeBinding/priority";
        public static final String DocumentTypeBinding_priority_Inverse = "http://www.simantics.org/Document-1.2/DocumentTypeBinding/priority/Inverse";
        public static final String FileDocument = "http://www.simantics.org/Document-1.2/FileDocument";
        public static final String Functions = "http://www.simantics.org/Document-1.2/Functions";
        public static final String Functions_documentationRootVariable = "http://www.simantics.org/Document-1.2/Functions/documentationRootVariable";
        public static final String Functions_documentationText = "http://www.simantics.org/Document-1.2/Functions/documentationText";
        public static final String Functions_standardEditText = "http://www.simantics.org/Document-1.2/Functions/standardEditText";
        public static final String HasDocument = "http://www.simantics.org/Document-1.2/HasDocument";
        public static final String HasDocumentTemplate = "http://www.simantics.org/Document-1.2/HasDocumentTemplate";
        public static final String HasDocumentTemplate_Inverse = "http://www.simantics.org/Document-1.2/HasDocumentTemplate/Inverse";
        public static final String HasDocument_Inverse = "http://www.simantics.org/Document-1.2/HasDocument/Inverse";
        public static final String HasDocumentation = "http://www.simantics.org/Document-1.2/HasDocumentation";
        public static final String HasDocumentation_Inverse = "http://www.simantics.org/Document-1.2/HasDocumentation/Inverse";
        public static final String HasLibraryRelation = "http://www.simantics.org/Document-1.2/HasLibraryRelation";
        public static final String HasNewerVersion = "http://www.simantics.org/Document-1.2/HasNewerVersion";
        public static final String HasOlderVersion = "http://www.simantics.org/Document-1.2/HasOlderVersion";
        public static final String HasReportFactory = "http://www.simantics.org/Document-1.2/HasReportFactory";
        public static final String HasReportFactory_Inverse = "http://www.simantics.org/Document-1.2/HasReportFactory/Inverse";
        public static final String HasUrl = "http://www.simantics.org/Document-1.2/HasUrl";
        public static final String HasUrl_Inverse = "http://www.simantics.org/Document-1.2/HasUrl/Inverse";
        public static final String HasVersionType = "http://www.simantics.org/Document-1.2/HasVersionType";
        public static final String PlainTextDocument = "http://www.simantics.org/Document-1.2/PlainTextDocument";
        public static final String PlainTextDocument_text = "http://www.simantics.org/Document-1.2/PlainTextDocument/text";
        public static final String PlainTextDocument_text_Inverse = "http://www.simantics.org/Document-1.2/PlainTextDocument/text/Inverse";
        public static final String PlainTextFileDocument = "http://www.simantics.org/Document-1.2/PlainTextFileDocument";
        public static final String PlainTextFileDocument_FilePath = "http://www.simantics.org/Document-1.2/PlainTextFileDocument/FilePath";
        public static final String PlainTextFileDocument_filePath = "http://www.simantics.org/Document-1.2/PlainTextFileDocument/filePath";
        public static final String PlainTextFileDocument_filePath_Inverse = "http://www.simantics.org/Document-1.2/PlainTextFileDocument/filePath/Inverse";
        @Deprecated public static final String Report = "http://www.simantics.org/Document-1.2/Report";
        public static final String Scenegraph = "http://www.simantics.org/Document-1.2/Scenegraph";
        public static final String ScenegraphDocument = "http://www.simantics.org/Document-1.2/ScenegraphDocument";
        public static final String ScenegraphDocument_scenegraph = "http://www.simantics.org/Document-1.2/ScenegraphDocument/scenegraph";
        public static final String ScenegraphDocument_scenegraph_Inverse = "http://www.simantics.org/Document-1.2/ScenegraphDocument/scenegraph/Inverse";
        public static final String Scenegraph_CategoryHidden = "http://www.simantics.org/Document-1.2/Scenegraph/CategoryHidden";
        public static final String Scenegraph_Composite = "http://www.simantics.org/Document-1.2/Scenegraph/Composite";
        public static final String Scenegraph_Diagram = "http://www.simantics.org/Document-1.2/Scenegraph/Diagram";
        public static final String Scenegraph_Diagram_path = "http://www.simantics.org/Document-1.2/Scenegraph/Diagram/path";
        public static final String Scenegraph_Diagram_path_Inverse = "http://www.simantics.org/Document-1.2/Scenegraph/Diagram/path/Inverse";
        public static final String Scenegraph_Node = "http://www.simantics.org/Document-1.2/Scenegraph/Node";
        public static final String Scenegraph_Node_editText = "http://www.simantics.org/Document-1.2/Scenegraph/Node/editText";
        public static final String Scenegraph_Node_editText_Inverse = "http://www.simantics.org/Document-1.2/Scenegraph/Node/editText/Inverse";
        public static final String Scenegraph_Node_printInPDF = "http://www.simantics.org/Document-1.2/Scenegraph/Node/printInPDF";
        public static final String Scenegraph_Node_printInPDF_Inverse = "http://www.simantics.org/Document-1.2/Scenegraph/Node/printInPDF/Inverse";
        public static final String Scenegraph_ParameterType = "http://www.simantics.org/Document-1.2/Scenegraph/ParameterType";
        public static final String Scenegraph_Wiki = "http://www.simantics.org/Document-1.2/Scenegraph/Wiki";
        public static final String Scenegraph_Wiki_text = "http://www.simantics.org/Document-1.2/Scenegraph/Wiki/text";
        public static final String Scenegraph_Wiki_text_Inverse = "http://www.simantics.org/Document-1.2/Scenegraph/Wiki/text/Inverse";
        public static final String UrlDocument = "http://www.simantics.org/Document-1.2/UrlDocument";
        public static final String WikiDocument = "http://www.simantics.org/Document-1.2/WikiDocument";
        public static final String WikiDocument_WikiDocumentBinding = "http://www.simantics.org/Document-1.2/WikiDocument/WikiDocumentBinding";
        public static final String WikiDocument_WikiDocumentTemplate = "http://www.simantics.org/Document-1.2/WikiDocument/WikiDocumentTemplate";
        public static final String WikiDocument_WikiDocumentTemplate_Header = "http://www.simantics.org/Document-1.2/WikiDocument/WikiDocumentTemplate/Header";
        public static final String WikiDocument_WikiDocumentTemplate_User = "http://www.simantics.org/Document-1.2/WikiDocument/WikiDocumentTemplate/User";
        public static final String WikiDocument_WikiDocumentTemplate_UserDocumentation = "http://www.simantics.org/Document-1.2/WikiDocument/WikiDocumentTemplate/UserDocumentation";
        public static final String WikiDocument_WikiDocumentTemplate_UserDocumentation_Inverse = "http://www.simantics.org/Document-1.2/WikiDocument/WikiDocumentTemplate/UserDocumentation/Inverse";
        public static final String WikiDocument_WikiText = "http://www.simantics.org/Document-1.2/WikiDocument/WikiText";
        public static final String WikiDocument_wikiText = "http://www.simantics.org/Document-1.2/WikiDocument/wikiText";
        public static final String WikiDocument_wikiText_Inverse = "http://www.simantics.org/Document-1.2/WikiDocument/wikiText/Inverse";
        public static final String cssDocument = "http://www.simantics.org/Document-1.2/cssDocument";
        public static final String cssDocument_Inverse = "http://www.simantics.org/Document-1.2/cssDocument/Inverse";
        public static final String documentSettings = "http://www.simantics.org/Document-1.2/documentSettings";
        public static final String documentSettings_Inverse = "http://www.simantics.org/Document-1.2/documentSettings/Inverse";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public DocumentResource(ReadGraph graph) {
        Document = getResourceOrNull(graph, URIs.Document);
        DocumentLibrary = getResourceOrNull(graph, URIs.DocumentLibrary);
        DocumentSettings = getResourceOrNull(graph, URIs.DocumentSettings);
        DocumentSettings_n$marginBottom = getResourceOrNull(graph, URIs.DocumentSettings_n$marginBottom);
        DocumentSettings_n$marginBottom_Inverse = getResourceOrNull(graph, URIs.DocumentSettings_n$marginBottom_Inverse);
        DocumentSettings_n$marginLeft = getResourceOrNull(graph, URIs.DocumentSettings_n$marginLeft);
        DocumentSettings_n$marginLeft_Inverse = getResourceOrNull(graph, URIs.DocumentSettings_n$marginLeft_Inverse);
        DocumentSettings_n$marginRight = getResourceOrNull(graph, URIs.DocumentSettings_n$marginRight);
        DocumentSettings_n$marginRight_Inverse = getResourceOrNull(graph, URIs.DocumentSettings_n$marginRight_Inverse);
        DocumentSettings_n$marginTop = getResourceOrNull(graph, URIs.DocumentSettings_n$marginTop);
        DocumentSettings_n$marginTop_Inverse = getResourceOrNull(graph, URIs.DocumentSettings_n$marginTop_Inverse);
        DocumentTemplate = getResourceOrNull(graph, URIs.DocumentTemplate);
        DocumentTypeBinding = getResourceOrNull(graph, URIs.DocumentTypeBinding);
        DocumentTypeBinding_HasDocumentType = getResourceOrNull(graph, URIs.DocumentTypeBinding_HasDocumentType);
        DocumentTypeBinding_HasDocumentType_Inverse = getResourceOrNull(graph, URIs.DocumentTypeBinding_HasDocumentType_Inverse);
        DocumentTypeBinding_HasType = getResourceOrNull(graph, URIs.DocumentTypeBinding_HasType);
        DocumentTypeBinding_HasType_Inverse = getResourceOrNull(graph, URIs.DocumentTypeBinding_HasType_Inverse);
        DocumentTypeBinding_priority = getResourceOrNull(graph, URIs.DocumentTypeBinding_priority);
        DocumentTypeBinding_priority_Inverse = getResourceOrNull(graph, URIs.DocumentTypeBinding_priority_Inverse);
        FileDocument = getResourceOrNull(graph, URIs.FileDocument);
        Functions = getResourceOrNull(graph, URIs.Functions);
        Functions_documentationRootVariable = getResourceOrNull(graph, URIs.Functions_documentationRootVariable);
        Functions_documentationText = getResourceOrNull(graph, URIs.Functions_documentationText);
        Functions_standardEditText = getResourceOrNull(graph, URIs.Functions_standardEditText);
        HasDocument = getResourceOrNull(graph, URIs.HasDocument);
        HasDocumentTemplate = getResourceOrNull(graph, URIs.HasDocumentTemplate);
        HasDocumentTemplate_Inverse = getResourceOrNull(graph, URIs.HasDocumentTemplate_Inverse);
        HasDocument_Inverse = getResourceOrNull(graph, URIs.HasDocument_Inverse);
        HasDocumentation = getResourceOrNull(graph, URIs.HasDocumentation);
        HasDocumentation_Inverse = getResourceOrNull(graph, URIs.HasDocumentation_Inverse);
        HasLibraryRelation = getResourceOrNull(graph, URIs.HasLibraryRelation);
        HasNewerVersion = getResourceOrNull(graph, URIs.HasNewerVersion);
        HasOlderVersion = getResourceOrNull(graph, URIs.HasOlderVersion);
        HasReportFactory = getResourceOrNull(graph, URIs.HasReportFactory);
        HasReportFactory_Inverse = getResourceOrNull(graph, URIs.HasReportFactory_Inverse);
        HasUrl = getResourceOrNull(graph, URIs.HasUrl);
        HasUrl_Inverse = getResourceOrNull(graph, URIs.HasUrl_Inverse);
        HasVersionType = getResourceOrNull(graph, URIs.HasVersionType);
        PlainTextDocument = getResourceOrNull(graph, URIs.PlainTextDocument);
        PlainTextDocument_text = getResourceOrNull(graph, URIs.PlainTextDocument_text);
        PlainTextDocument_text_Inverse = getResourceOrNull(graph, URIs.PlainTextDocument_text_Inverse);
        PlainTextFileDocument = getResourceOrNull(graph, URIs.PlainTextFileDocument);
        PlainTextFileDocument_FilePath = getResourceOrNull(graph, URIs.PlainTextFileDocument_FilePath);
        PlainTextFileDocument_filePath = getResourceOrNull(graph, URIs.PlainTextFileDocument_filePath);
        PlainTextFileDocument_filePath_Inverse = getResourceOrNull(graph, URIs.PlainTextFileDocument_filePath_Inverse);
        Report = getResourceOrNull(graph, URIs.Report);
        Scenegraph = getResourceOrNull(graph, URIs.Scenegraph);
        ScenegraphDocument = getResourceOrNull(graph, URIs.ScenegraphDocument);
        ScenegraphDocument_scenegraph = getResourceOrNull(graph, URIs.ScenegraphDocument_scenegraph);
        ScenegraphDocument_scenegraph_Inverse = getResourceOrNull(graph, URIs.ScenegraphDocument_scenegraph_Inverse);
        Scenegraph_CategoryHidden = getResourceOrNull(graph, URIs.Scenegraph_CategoryHidden);
        Scenegraph_Composite = getResourceOrNull(graph, URIs.Scenegraph_Composite);
        Scenegraph_Diagram = getResourceOrNull(graph, URIs.Scenegraph_Diagram);
        Scenegraph_Diagram_path = getResourceOrNull(graph, URIs.Scenegraph_Diagram_path);
        Scenegraph_Diagram_path_Inverse = getResourceOrNull(graph, URIs.Scenegraph_Diagram_path_Inverse);
        Scenegraph_Node = getResourceOrNull(graph, URIs.Scenegraph_Node);
        Scenegraph_Node_editText = getResourceOrNull(graph, URIs.Scenegraph_Node_editText);
        Scenegraph_Node_editText_Inverse = getResourceOrNull(graph, URIs.Scenegraph_Node_editText_Inverse);
        Scenegraph_Node_printInPDF = getResourceOrNull(graph, URIs.Scenegraph_Node_printInPDF);
        Scenegraph_Node_printInPDF_Inverse = getResourceOrNull(graph, URIs.Scenegraph_Node_printInPDF_Inverse);
        Scenegraph_ParameterType = getResourceOrNull(graph, URIs.Scenegraph_ParameterType);
        Scenegraph_Wiki = getResourceOrNull(graph, URIs.Scenegraph_Wiki);
        Scenegraph_Wiki_text = getResourceOrNull(graph, URIs.Scenegraph_Wiki_text);
        Scenegraph_Wiki_text_Inverse = getResourceOrNull(graph, URIs.Scenegraph_Wiki_text_Inverse);
        UrlDocument = getResourceOrNull(graph, URIs.UrlDocument);
        WikiDocument = getResourceOrNull(graph, URIs.WikiDocument);
        WikiDocument_WikiDocumentBinding = getResourceOrNull(graph, URIs.WikiDocument_WikiDocumentBinding);
        WikiDocument_WikiDocumentTemplate = getResourceOrNull(graph, URIs.WikiDocument_WikiDocumentTemplate);
        WikiDocument_WikiDocumentTemplate_Header = getResourceOrNull(graph, URIs.WikiDocument_WikiDocumentTemplate_Header);
        WikiDocument_WikiDocumentTemplate_User = getResourceOrNull(graph, URIs.WikiDocument_WikiDocumentTemplate_User);
        WikiDocument_WikiDocumentTemplate_UserDocumentation = getResourceOrNull(graph, URIs.WikiDocument_WikiDocumentTemplate_UserDocumentation);
        WikiDocument_WikiDocumentTemplate_UserDocumentation_Inverse = getResourceOrNull(graph, URIs.WikiDocument_WikiDocumentTemplate_UserDocumentation_Inverse);
        WikiDocument_WikiText = getResourceOrNull(graph, URIs.WikiDocument_WikiText);
        WikiDocument_wikiText = getResourceOrNull(graph, URIs.WikiDocument_wikiText);
        WikiDocument_wikiText_Inverse = getResourceOrNull(graph, URIs.WikiDocument_wikiText_Inverse);
        cssDocument = getResourceOrNull(graph, URIs.cssDocument);
        cssDocument_Inverse = getResourceOrNull(graph, URIs.cssDocument_Inverse);
        documentSettings = getResourceOrNull(graph, URIs.documentSettings);
        documentSettings_Inverse = getResourceOrNull(graph, URIs.documentSettings_Inverse);
    }
    
    public static DocumentResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        DocumentResource ret = session.peekService(DocumentResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new DocumentResource(qc.getIndependentGraph(graph));
            session.registerService(DocumentResource.class, ret);
        }
        return ret;
    }
    
    public static DocumentResource getInstance(RequestProcessor session) throws DatabaseException {
        DocumentResource ret = session.peekService(DocumentResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<DocumentResource>() {
                public DocumentResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new DocumentResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(DocumentResource.class, ret);
        }
        return ret;
    }
    
}

