/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.document.linking.report.templates.CompleteStructureWriter;
import org.simantics.document.linking.report.templates.DiagramStructureWithDependenciesWriter;
import org.simantics.document.linking.report.templates.DiagramStructureWriter;
import org.simantics.document.linking.report.templates.DocumentStructureWriter;
import org.simantics.document.linking.report.templates.ModelDocumentWriter;
import org.simantics.document.linking.report.templates.ReferredDocumentWriter;
import org.simantics.document.linking.report.templates.ReportWriter;
import org.simantics.document.linking.views.ModelRead;
import org.simantics.document.linking.views.ModelToComboListener;
import org.simantics.ui.SimanticsUI;

public class ReportSelectionPage
extends WizardPage {
    CCombo modelCombo;
    Text filenameText;
    Button browseButton;
    ModelToComboListener modelToComboListener;
    List<Button> reportSelectionButtons = new ArrayList<Button>();
    List<ReportWriter<?>> reportWriters = new ArrayList();
    ReportWriter<?> selectedWriter;
    Resource selectedModel;
    Resource input;

    protected ReportSelectionPage(String pageName) {
        super(pageName, pageName, null);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText("Model:");
        this.modelCombo = new CCombo(composite, 2056);
        label = new Label(composite, 0);
        label.setText("File:");
        this.filenameText = new Text(composite, 2052);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText("Browse");
        this.reportWriters.add(new ModelDocumentWriter());
        this.reportWriters.add(new ReferredDocumentWriter());
        this.reportWriters.add(new DocumentStructureWriter());
        this.reportWriters.add(new DiagramStructureWriter());
        this.reportWriters.add(new DiagramStructureWithDependenciesWriter());
        this.reportWriters.add(new CompleteStructureWriter());
        Group group = new Group(composite, 0);
        group.setText("Report templates");
        group.setLayout((Layout)new FillLayout(512));
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.filenameText);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.modelCombo);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)group);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.pdf", "*.html"});
                dialog.setFilterNames(new String[]{"PDF Document", "HTML Document"});
                String filename = dialog.open();
                if (filename == null) {
                    ReportSelectionPage.this.filenameText.setText("");
                } else {
                    ReportSelectionPage.this.filenameText.setText(filename);
                }
                ReportSelectionPage.this.validate();
            }
        });
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button selected = (Button)e.widget;
                ReportSelectionPage.this.select(selected);
            }
        };
        for (ReportWriter<?> rw : this.reportWriters) {
            Button b = new Button((Composite)group, 16);
            b.setText(rw.getName());
            b.setData(rw);
            b.addSelectionListener((SelectionListener)listener);
            this.reportSelectionButtons.add(b);
        }
        SimanticsUI.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Resource project = (Resource)SimanticsUI.getProject().get();
                ReportSelectionPage.this.modelToComboListener = new ModelToComboListener(ReportSelectionPage.this.modelCombo){

                    @Override
                    public Resource getCurrentModel() {
                        return (this).ReportSelectionPage.this.selectedModel;
                    }

                    @Override
                    public void loaded() {
                        ReportSelectionPage.this.preselectModel();
                    }
                };
                graph.syncRequest((Read)new ModelRead(project), (Listener)ReportSelectionPage.this.modelToComboListener);
            }
        });
        this.modelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ReportSelectionPage.this.modelCombo.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                Resource model = (Resource)ReportSelectionPage.this.modelCombo.getData(Integer.toString(index));
                if (model != null) {
                    ReportSelectionPage.this.selectedModel = model;
                }
                ReportSelectionPage.this.validate();
            }
        });
        this.select(this.reportSelectionButtons.get(0));
        this.setControl((Control)composite);
    }

    public List<Button> getReportSelectionButtons() {
        return this.reportSelectionButtons;
    }

    private void select(Button selected) {
        selected.setSelection(true);
        for (Button b : this.reportSelectionButtons) {
            if (b == selected) continue;
            b.setSelection(false);
        }
        this.selectedWriter = (ReportWriter)selected.getData();
        this.validate();
    }

    private void validate() {
        this.setPageComplete(this.selectedWriter != null && this.selectedModel != null && this.filenameText.getText().length() > 0);
    }

    public ReportWriter<?> getSelectedWriter() {
        return this.selectedWriter;
    }

    public String getFilename() {
        return this.filenameText.getText();
    }

    public Resource getSelectedModel() {
        return this.selectedModel;
    }

    public void setInput(Resource input) {
        this.input = input;
    }

    private void preselectModel() {
        if (this.input != null) {
            int i = 0;
            while (i < this.modelCombo.getItemCount()) {
                if (this.input.equals(this.modelCombo.getData(Integer.toString(i)))) {
                    this.modelCombo.select(i);
                    this.selectedModel = this.input;
                }
                ++i;
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.preselectModel();
        }
        super.setVisible(visible);
    }
}

