/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Display;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.procedure.Listener;

public abstract class ModelToComboListener
implements Listener<Collection<NamedResource>> {
    private CCombo combo;
    private boolean disposed = false;

    public ModelToComboListener(CCombo combo) {
        this.combo = combo;
    }

    public abstract Resource getCurrentModel();

    public void execute(final Collection<NamedResource> result) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ModelToComboListener.this.combo.isDisposed()) {
                    ModelToComboListener.this.disposed = true;
                    return;
                }
                ArrayList models = new ArrayList();
                models.addAll(result);
                Collections.sort(models);
                int index = -1;
                ModelToComboListener.this.combo.removeAll();
                index = -1;
                int i = 0;
                for (NamedResource model : models) {
                    ModelToComboListener.this.combo.add(model.getName());
                    ModelToComboListener.this.combo.setData(Integer.toString(i), (Object)model.getResource());
                    if (model.getResource().equals(ModelToComboListener.this.getCurrentModel())) {
                        index = i;
                    }
                    ++i;
                }
                if (index >= 0) {
                    ModelToComboListener.this.combo.select(index);
                }
                ModelToComboListener.this.loaded();
            }
        });
    }

    public void loaded() {
    }

    public void exception(Throwable t) {
    }

    public boolean isDisposed() {
        return this.disposed || this.combo.isDisposed();
    }

    public void dispose() {
        this.disposed = true;
    }
}

