/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.adapter.RouteGraphUtils;
import org.simantics.diagram.adapter.SyncElementFactory;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteGraphConnectionClass;
import org.simantics.diagram.connection.rendering.ConnectionStyle;
import org.simantics.diagram.connection.rendering.StyledRouteGraphRenderer;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;
import org.simantics.diagram.content.ResourceTerminal;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.connection.ConnectionEntity;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.g2d.nodes.connection.IRouteGraphListener;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphChangeEvent;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.IModelingRules;

public class RouteGraphConnectionClassFactory
extends SyncElementFactory {
    public static final ElementClass CLASS = RouteGraphConnectionClass.CLASS;
    public static final ILineEndStyle HEAD = RouteGraphUtils.HEAD;
    public static final ILineEndStyle TAIL = RouteGraphUtils.TAIL;
    protected Layer0 L0;
    protected DiagramResource DIA;
    protected StructuralResource2 STR;
    protected ModelingResources MOD;

    public RouteGraphConnectionClassFactory(ReadGraph graph) {
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
        this.STR = StructuralResource2.getInstance((ReadGraph)graph);
        this.MOD = ModelingResources.getInstance((ReadGraph)graph);
    }

    @Override
    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, (Object)CLASS.newClassWith(false, new ElementHandler[]{new StaticObjectAdapter((Object)elementType)}));
    }

    @Override
    protected Resource getElementClassBaseType(AsyncReadGraph graph) {
        return this.DIA.Connection;
    }

    @Override
    public void load(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, final Resource connection, IElement element) throws DatabaseException {
        IModelingRules modelingRules = (IModelingRules)diagram.getHint(DiagramModelHints.KEY_MODELING_RULES);
        Resource diagramRuntime = (Resource)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RUNTIME_RESOURCE);
        THashSet backendConnections = new THashSet();
        RouteGraph rg = RouteGraphUtils.load(graph, diagramRuntime, connection, canvas, diagram, modelingRules, (Set<RouteGraphUtils.BackendConnection>)backendConnections);
        ConnectionStyle style = RouteGraphUtils.readConnectionStyle(graph, modelingRules, connection, this.STR);
        StyledRouteGraphRenderer renderer = RouteGraphUtils.getRenderer(graph, style);
        element.setHint(RouteGraphConnectionClass.KEY_ROUTEGRAPH, (Object)rg);
        element.setHint(RouteGraphConnectionClass.KEY_RENDERER, (Object)renderer);
        element.setHint(RouteGraphConnectionClass.KEY_PICK_TOLERANCE, (Object)0.5);
        element.setHint(ElementHints.KEY_CONNECTION_ENTITY, (Object)new CE(diagram, connection, element, (Set<RouteGraphUtils.BackendConnection>)backendConnections));
        final Session session = graph.getSession();
        element.setHint(RouteGraphConnectionClass.KEY_RG_LISTENER, (Object)new IRouteGraphListener(){

            public void routeGraphChanged(RouteGraphChangeEvent event) {
                RouteGraphUtils.scheduleSynchronize(session, connection, event);
            }
        });
    }

    public static class CE
    implements ConnectionEntity {
        final IDiagram diagram;
        final Resource connection;
        IElement connectionElement;
        final Set<RouteGraphUtils.BackendConnection> backendConnections;
        transient Set<Topology.Connection> terminalConnections;

        public CE(IDiagram diagram, Resource connection, IElement connectionElement, Set<RouteGraphUtils.BackendConnection> backendConnections) {
            if (connectionElement == null) {
                throw new NullPointerException("null connection element");
            }
            this.diagram = diagram;
            this.connection = connection;
            this.connectionElement = connectionElement;
            this.backendConnections = backendConnections;
            IElement ce = this.getConnection0();
            if (ce != null) {
                this.connectionElement = ce;
            }
        }

        public IElement getConnection0() {
            DataElementMap dem = (DataElementMap)this.diagram.getDiagramClass().getSingleItem(DataElementMap.class);
            IElement connectionElement = dem.getElement(this.diagram, (Object)this.connection);
            return connectionElement;
        }

        public IElement getConnection() {
            IElement c = this.getConnection0();
            if (c == null) {
                c = this.connectionElement;
            }
            return c;
        }

        public Collection<IElement> getBranchPoints(Collection<IElement> result) {
            return result != null ? result : Collections.emptyList();
        }

        public Collection<IElement> getSegments(Collection<IElement> result) {
            return result != null ? result : Collections.emptyList();
        }

        public Collection<Topology.Connection> getTerminalConnections(Collection<Topology.Connection> result) {
            if (this.terminalConnections == null) {
                this.terminalConnections = this.calculateTerminalConnections();
            }
            if (result == null) {
                result = new ArrayList<Topology.Connection>(this.terminalConnections);
            } else {
                result.addAll(this.terminalConnections);
            }
            return this.terminalConnections;
        }

        private Set<Topology.Connection> calculateTerminalConnections() {
            THashSet result = new THashSet(this.backendConnections.size());
            DataElementMap dem = (DataElementMap)this.diagram.getDiagramClass().getSingleItem(DataElementMap.class);
            IElement connectionElement = dem.getElement(this.diagram, (Object)this.connection);
            if (connectionElement == null) {
                throw new NullPointerException("connection is not mapped");
            }
            ArrayList ts = new ArrayList();
            block0: for (RouteGraphUtils.BackendConnection bc : this.backendConnections) {
                IElement e = dem.getElement(this.diagram, (Object)bc.node);
                if (e == null) continue;
                TerminalTopology tt = (TerminalTopology)e.getElementClass().getSingleItem(TerminalTopology.class);
                ts.clear();
                tt.getTerminals(e, ts);
                for (Topology.Terminal t : ts) {
                    ResourceTerminal rt;
                    if (!(t instanceof ResourceTerminal) || !bc.terminal.equals((rt = (ResourceTerminal)t).getResource())) continue;
                    result.add(new Topology.Connection(connectionElement, bc.end, e, t));
                    continue block0;
                }
            }
            return result;
        }

        public void setListener(ConnectionEntity.ConnectionListener listener) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "[resource=" + this.connection + ", connectionElement=" + this.getConnection() + "]";
        }
    }
}

