/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.adapter.FlagTextInfo;
import org.simantics.diagram.adapter.SVGImageInfo;
import org.simantics.diagram.adapter.SyncElementFactory;
import org.simantics.diagram.content.ResourceTerminal;
import org.simantics.diagram.flag.AbstractFlagType;
import org.simantics.diagram.flag.BasicFlagType;
import org.simantics.diagram.flag.FlagSceneGraph;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.flag.IFlagType;
import org.simantics.diagram.flag.IFlagTypeReader;
import org.simantics.diagram.function.All;
import org.simantics.diagram.function.PredefinedVariables;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.query.FlagTables;
import org.simantics.diagram.query.FlagTypeFilter;
import org.simantics.diagram.query.FlagTypeFilters;
import org.simantics.diagram.query.FlagTypeVisual;
import org.simantics.diagram.query.FlagTypeVisuals;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.CompositeHintSynchronizer;
import org.simantics.diagram.synchronization.IHintSynchronizer;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.FlagSynchronizer;
import org.simantics.diagram.synchronization.graph.TransformSynchronizer;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.TextEditor;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.g2d.elementclass.FlagHandler;
import org.simantics.g2d.utils.Alignment;
import org.simantics.g2d.utils.geom.DirectionSet;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.utils.ui.ErrorLogger;

public class FlagClassFactory
extends SyncElementFactory {
    private static final Bean[] NO_BEANS = new Bean[0];
    private static final IHintSynchronizer HINT_SYNCHRONIZER = new CompositeHintSynchronizer(FlagSynchronizer.INSTANCE, TransformSynchronizer.INSTANCE);

    public static ElementClass createFlagClass(Resource elementClass, Resource terminalResource) {
        ResourceTerminal terminal = new ResourceTerminal(terminalResource, new AffineTransform(), DirectionSet.ANY);
        return FlagClass.create((Topology.Terminal)terminal, (SceneGraph)FlagSceneGraph.INSTANCE).newClassWith(new ElementHandler[]{new StaticObjectAdapter((Object)elementClass)});
    }

    @Override
    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, AsyncProcedure<ElementClass> procedure) {
        DiagramResource DIA = (DiagramResource)graph.getService(DiagramResource.class);
        procedure.execute(graph, (Object)FlagClassFactory.createFlagClass(DIA.Flag, DIA.Flag_Terminal));
    }

    @Override
    public void load(ReadGraph g, ICanvasContext canvas, IDiagram diagram, Resource flag, IElement e) throws DatabaseException {
        Resource flagTypeVisual;
        FlagClass.Mode mode;
        FlagClass.Type type;
        Layer0 l0 = (Layer0)g.getService(Layer0.class);
        DiagramResource dr = (DiagramResource)g.getService(DiagramResource.class);
        ElementClass ec = e.getElementClass();
        FlagHandler fh = (FlagHandler)ec.getSingleItem(FlagHandler.class);
        fh.connectData(e, (Object)flag, (Object)FlagUtil.getPossibleCounterpart(g, flag));
        fh.setExternal(e, FlagUtil.isExternal(g, flag));
        TextEditor ed = (TextEditor)ec.getAtMostOneItemOfClass(TextEditor.class);
        if (ed != null) {
            final Session session = g.getSession();
            ed.setModifier(e, new TextEditor.Modifier(){

                public String getValue(IElement element) {
                    String s = ElementUtils.getText((IElement)element);
                    return s != null ? s : "";
                }

                public String isValid(IElement element, String text) {
                    return null;
                }

                public void modify(IElement element, final String text) {
                    final Resource flag = (Resource)ElementUtils.getObject((IElement)element);
                    try {
                        session.syncRequest((Write)new WriteRequest(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                                DiagramGraphUtil.setRelatedValue(graph, flag, l0.HasLabel, l0.String, text, (Binding)Bindings.STRING);
                                Resource otherFlag = FlagUtil.getPossibleCounterpart((ReadGraph)graph, flag);
                                if (otherFlag != null) {
                                    DiagramGraphUtil.setRelatedValue(graph, otherFlag, l0.HasLabel, l0.String, text, (Binding)Bindings.STRING);
                                }
                            }
                        });
                    }
                    catch (DatabaseException e) {
                        ErrorLogger.defaultLogError((String)"Flag label editing failed, see exception for details.", (Throwable)e);
                    }
                }
            });
        }
        Resource diagramRuntime = (Resource)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RUNTIME_RESOURCE);
        AffineTransform at = DiagramGraphUtil.getDynamicAffineTransform(g, diagramRuntime, flag);
        ElementUtils.setTransform((IElement)e, (AffineTransform)at);
        String label = (String)g.getPossibleRelatedValue(flag, l0.HasLabel);
        if (label == null) {
            label = "";
        }
        ElementUtils.setText((IElement)e, (String)label);
        boolean shapeIsSet = false;
        boolean flagTextIsSet = false;
        boolean flagTypeIsSet = false;
        boolean textAreaIsSet = false;
        e.setHint(FlagClass.KEY_TEXT_HORIZONTAL_ALIGN, (Object)Alignment.LEADING);
        e.setHint(FlagClass.KEY_TEXT_VERTICAL_ALIGN, (Object)Alignment.CENTER);
        IModelingRules modelingRules = (IModelingRules)diagram.getHint(DiagramModelHints.KEY_MODELING_RULES);
        if (modelingRules != null) {
            Resource connectionType = DiagramGraphUtil.getConnectionTypeForFlag(g, flag);
            IFlagTypeReader ftr = null;
            if (connectionType != null) {
                ftr = (IFlagTypeReader)g.getPossibleAdapter(connectionType, IFlagTypeReader.class);
            }
            if (ftr == null) {
                ftr = (IFlagTypeReader)g.getPossibleAdapter(flag, IFlagTypeReader.class);
            }
            if (ftr != null) {
                String[] flagText;
                FlagClass.Type type2;
                IFlagType ft = ftr.read(g, flag, modelingRules);
                IFlagType.FlagInfo info = ft.getInfo(g, canvas);
                Shape shape = info.getShape();
                if (shape != null) {
                    e.setHint(FlagClass.KEY_SHAPE, (Object)shape);
                    shapeIsSet = true;
                }
                if ((type2 = info.getType()) != null) {
                    e.setHint(FlagClass.KEY_FLAG_TYPE, (Object)type2);
                    flagTypeIsSet = true;
                }
                if ((flagText = info.getText()) != null) {
                    e.setHint(FlagClass.KEY_FLAG_TEXT, (Object)flagText);
                    flagTextIsSet = true;
                }
                if (info.getTextArea() != null) {
                    e.setHint(FlagClass.KEY_FLAG_TEXT_AREA, (Object)info.getTextArea());
                    textAreaIsSet = true;
                }
                if (info.getHorizontalAlignment() != null) {
                    e.setHint(FlagClass.KEY_TEXT_HORIZONTAL_ALIGN, (Object)info.getHorizontalAlignment());
                }
                if (info.getVerticalAlignment() != null) {
                    e.setHint(FlagClass.KEY_TEXT_VERTICAL_ALIGN, (Object)info.getVerticalAlignment());
                }
            }
        }
        if (!flagTypeIsSet) {
            e.setHint(FlagClass.KEY_FLAG_TYPE, (Object)DiagramGraphUtil.toFlagType(dr, g.getPossibleObject(flag, dr.HasFlagType), FlagClass.Type.In));
        }
        if (!flagTextIsSet) {
            e.setHint(FlagClass.KEY_FLAG_TEXT, g.syncRequest(DiagramRequests.getFlagText(flag)));
        }
        if (!textAreaIsSet) {
            type = (FlagClass.Type)e.getHint(FlagClass.KEY_FLAG_TYPE);
            mode = AbstractFlagType.getMode(g, flag);
            e.setHint(FlagClass.KEY_FLAG_TEXT_AREA, (Object)BasicFlagType.getArea(type, mode));
        }
        if (!shapeIsSet) {
            type = (FlagClass.Type)e.getHint(FlagClass.KEY_FLAG_TYPE);
            mode = AbstractFlagType.getMode(g, flag);
            e.setHint(FlagClass.KEY_SHAPE, (Object)BasicFlagType.getShape(type, mode));
        }
        e.setHint(SynchronizationHints.HINT_SYNCHRONIZER, (Object)HINT_SYNCHRONIZER);
        e.setHint(FlagSceneGraph.KEY_FLAG_VISUALS, (Object)NO_BEANS);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource template = diagramRuntime != null ? All.getTemplate(g, diagramRuntime) : null;
        Resource flagTable = FlagClassFactory.getFlagTable(g, template, flag);
        if (template != null && flagTable != null && (flagTypeVisual = this.getVisualOfFlag(g, template, flagTable, flag)) != null) {
            Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)g);
            float tableWidth = ((Float)g.getRelatedValue(flagTable, TEMPLATE2D.FlagTable_HasWidth, (Binding)Bindings.FLOAT)).floatValue();
            Resource align = g.getPossibleObject(flagTable, TEMPLATE2D.FlagTable_HasAlignment);
            float height = ((Float)g.getRelatedValue(flagTable, TEMPLATE2D.FlagTable_HasRowHeigth, (Binding)Bindings.FLOAT)).floatValue();
            float halfHeight = height / 2.0f;
            float horizontalOffset = tableWidth;
            if (align != null) {
                if (align.equals(TEMPLATE2D.FlagTable_Alignment_Left)) {
                    horizontalOffset = 0.0f;
                } else if (align.equals(TEMPLATE2D.FlagTable_Alignment_Right)) {
                    tableWidth = -tableWidth;
                    horizontalOffset = -horizontalOffset;
                }
            }
            Collection monitorsAndTexts = g.getObjects(flagTypeVisual, L0.ConsistsOf);
            List<Bean> flagVisuals = Collections.emptyList();
            if (!monitorsAndTexts.isEmpty()) {
                flagVisuals = new ArrayList(monitorsAndTexts.size());
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
                Resource diagramResource = (Resource)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
                Resource compositeResource = g.getSingleObject(diagramResource, MOD.DiagramToComposite);
                Variable compositeVariable = Variables.getVariable((ReadGraph)g, (Resource)compositeResource);
                for (Resource visual : monitorsAndTexts) {
                    String path;
                    FlagTextInfo i;
                    if (!this.acceptVisual(g, flag, visual)) continue;
                    if (g.isInstanceOf(visual, DIA.Scenegraph_Monitor)) {
                        i = (FlagTextInfo)((Object)g.syncRequest((Read)new ReadFlagTextInfo(visual), (Listener)TransientCacheListener.instance()));
                        FlagTextInfo monitorInfo = (FlagTextInfo)i.clone();
                        if (monitorInfo.transform != null) {
                            monitorInfo.transform[4] = monitorInfo.transform[4] + (double)horizontalOffset;
                        }
                        path = (String)g.getRelatedValue(visual, DIA.Scenegraph_Monitor_reference, (Binding)Bindings.STRING);
                        String value = "";
                        if (path != null && path.length() > 0) {
                            value = FlagClassFactory.evaluatePath(g, flag, path);
                        }
                        monitorInfo.text = value;
                        monitorInfo.id = Long.toString(visual.getResourceId());
                        flagVisuals.add(monitorInfo);
                        continue;
                    }
                    if (g.isInstanceOf(visual, DIA.Scenegraph_Text)) {
                        i = (FlagTextInfo)((Object)g.syncRequest((Read)new ReadFlagTextInfo(visual), (Listener)TransientCacheListener.instance()));
                        FlagTextInfo info = (FlagTextInfo)i.clone();
                        if (info.transform != null) {
                            info.transform[4] = info.transform[4] + (double)horizontalOffset;
                        }
                        if ((path = (String)g.getRelatedValue(visual, DIA.Scenegraph_Text_text, (Binding)Bindings.STRING)) != null && path.length() > 0) {
                            info.text = path;
                        }
                        info.id = Long.toString(visual.getResourceId());
                        flagVisuals.add(info);
                        continue;
                    }
                    if (!g.isInstanceOf(visual, DIA.Scenegraph_SVGImage)) continue;
                    SVGImageInfo info = (SVGImageInfo)((Object)g.syncRequest((Read)new ReadSVGImageInfo(visual, compositeResource, compositeVariable), (Listener)TransientCacheListener.instance()));
                    flagVisuals.add(info);
                }
            }
            if (flagVisuals.size() > 0) {
                Rectangle2D.Double newShape = new Rectangle2D.Double();
                newShape.setFrameFromDiagonal(0.0, -halfHeight, tableWidth, halfHeight);
                e.setHint(FlagClass.KEY_SHAPE, (Object)newShape);
                e.setHint(FlagSceneGraph.KEY_FLAG_VISUALS, (Object)flagVisuals.toArray(NO_BEANS));
            }
        }
    }

    private static String evaluatePath(ReadGraph graph, Resource resource, String path) throws DatabaseException {
        Variable resourceVariable = Variables.getPossibleVariable((ReadGraph)graph, (Resource)resource);
        if (resourceVariable == null) {
            return "";
        }
        return FlagClassFactory.evaluatePath(graph, resource, resourceVariable, path);
    }

    private static String evaluatePath(ReadGraph graph, Resource resource, Variable resourceVariable, String path) throws DatabaseException {
        PredefinedVariables vars = PredefinedVariables.getInstance();
        Variable property = vars.getVariable(graph, path, resource, resourceVariable);
        if (property == null) {
            return "";
        }
        Object value = property.getPossibleValue(graph);
        if (value == null || !(value instanceof String)) {
            return "";
        }
        return value.toString();
    }

    private static FlagTextInfo createTextInfo(ReadGraph g, Resource visual) throws DatabaseException {
        Boolean wrapText;
        Float borderWidth;
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        FlagTextInfo info = new FlagTextInfo();
        info.id = Long.toString(visual.getResourceId());
        info.font = (Font)g.getPossibleRelatedValue2(visual, DIA.Scenegraph_AbstractText_font, Bindings.getBindingUnchecked(Font.class));
        info.color = (RGB.Integer)g.getPossibleRelatedValue2(visual, DIA.Scenegraph_AbstractText_color, RGB.Integer.BINDING);
        info.borderColor = (RGB.Integer)g.getPossibleRelatedValue2(visual, DIA.Scenegraph_AbstractText_borderColor, RGB.Integer.BINDING);
        info.backgroundColor = (RGB.Integer)g.getPossibleRelatedValue2(visual, DIA.Scenegraph_AbstractText_backgroundColor, RGB.Integer.BINDING);
        Float width = (Float)g.getPossibleRelatedValue2(visual, DIA.Scenegraph_AbstractText_width, Bindings.getBindingUnchecked(Float.class));
        if (width != null) {
            info.width = width.floatValue();
        }
        if ((borderWidth = (Float)g.getPossibleRelatedValue2(visual, DIA.Scenegraph_AbstractText_borderWidth, Bindings.getBindingUnchecked(Float.class))) != null) {
            info.borderWidth = borderWidth.floatValue();
        }
        if ((wrapText = (Boolean)g.getRelatedValue2(visual, DIA.Scenegraph_AbstractText_wrapText, (Binding)Bindings.BOOLEAN)) != null) {
            info.wrapText = wrapText;
        }
        info.hAlignment = Alignment.LEADING;
        Byte hAlignment = (Byte)g.getPossibleRelatedValue2(visual, DIA.Scenegraph_AbstractText_horizontalAlignment, (Binding)Bindings.BYTE);
        if (hAlignment != null) {
            if (hAlignment == 1) {
                info.hAlignment = Alignment.TRAILING;
            } else if (hAlignment == 2) {
                info.hAlignment = Alignment.CENTER;
            }
        }
        info.vAlignment = Alignment.LEADING;
        Byte vAlignment = (Byte)g.getPossibleRelatedValue2(visual, DIA.Scenegraph_AbstractText_verticalAlignment, (Binding)Bindings.BYTE);
        if (vAlignment != null) {
            if (vAlignment == 1) {
                info.vAlignment = Alignment.TRAILING;
            } else if (vAlignment == 2) {
                info.vAlignment = Alignment.CENTER;
            } else if (vAlignment == 3) {
                info.vAlignment = Alignment.BASELINE;
            }
        }
        info.transform = (double[])g.getPossibleRelatedValue2(visual, DIA.Scenegraph_AbstractText_transform, Bindings.getBindingUnchecked(double[].class));
        return info;
    }

    private static Resource getFlagTable(ReadGraph g, Resource template, Resource flag) throws DatabaseException {
        if (template == null || flag == null) {
            return null;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        String tableName = (String)g.getPossibleRelatedValue(flag, DIA.Flag_HasIOTableBinding, (Binding)Bindings.STRING);
        if (tableName == null) {
            return null;
        }
        Map flagTables = (Map)g.syncRequest((Read)new FlagTables(template), (Listener)TransientCacheListener.instance());
        return (Resource)flagTables.get(tableName);
    }

    private Resource getVisualOfFlag(ReadGraph g, Resource template, Resource flagTable, Resource flag) throws DatabaseException {
        if (template == null || flagTable == null || flag == null) {
            return null;
        }
        List flagTypeVisuals = (List)g.syncRequest((Read)new FlagTypeVisuals(flagTable), (Listener)TransientCacheListener.instance());
        if (flagTypeVisuals == null || flagTypeVisuals.isEmpty()) {
            return null;
        }
        Variable flagVariable = Variables.getPossibleVariable((ReadGraph)g, (Resource)flag);
        if (flagVariable == null) {
            return null;
        }
        for (FlagTypeVisual visual : flagTypeVisuals) {
            Resource visualComposite;
            block10: {
                visualComposite = visual.getVisualComposite();
                String filterReference = visual.getFilteredPropertyReference();
                if (filterReference == null || filterReference.isEmpty()) {
                    return visualComposite;
                }
                String filterPattern = visual.getFilterPattern();
                if (filterPattern == null || filterPattern.isEmpty()) {
                    return visualComposite;
                }
                String value = FlagClassFactory.evaluatePath(g, flag, flagVariable, filterReference);
                if (value == null) {
                    return visualComposite;
                }
                try {
                    if (!Pattern.matches(filterPattern, value)) {
                    }
                    break block10;
                }
                catch (PatternSyntaxException ex) {
                    ErrorLogger.defaultLogError((Throwable)ex);
                }
                continue;
            }
            return visualComposite;
        }
        return null;
    }

    private boolean acceptVisual(ReadGraph graph, Resource flag, Resource visual) throws DatabaseException {
        List filters = (List)graph.syncRequest((Read)new FlagTypeFilters(visual), (Listener)TransientCacheListener.instance());
        if (filters.isEmpty()) {
            return true;
        }
        Variable flagVariable = Variables.getPossibleVariable((ReadGraph)graph, (Resource)flag);
        if (flagVariable == null) {
            return false;
        }
        for (FlagTypeFilter filter : filters) {
            String value;
            String pattern;
            String reference = filter.getReference();
            if (reference == null || reference.isEmpty() || (pattern = filter.getPattern()) == null || pattern.isEmpty() || (value = FlagClassFactory.evaluatePath(graph, flag, flagVariable, reference)) == null) continue;
            try {
                if (Pattern.matches(pattern, value) != filter.isMatchRequired()) continue;
                return true;
            }
            catch (PatternSyntaxException ex) {
                ErrorLogger.defaultLogError((Throwable)ex);
            }
        }
        return false;
    }

    static class ReadFlagTextInfo
    extends ResourceRead<FlagTextInfo> {
        public ReadFlagTextInfo(Resource textNode) {
            super(textNode);
        }

        public FlagTextInfo perform(ReadGraph graph) throws DatabaseException {
            return FlagClassFactory.createTextInfo(graph, this.resource);
        }
    }

    static class ReadSVGImageInfo
    extends TernaryRead<Resource, Resource, Variable, SVGImageInfo> {
        public ReadSVGImageInfo(Resource svgImageNode, Resource composite, Variable compositeVariable) {
            super((Object)svgImageNode, (Object)composite, (Object)compositeVariable);
        }

        public SVGImageInfo perform(ReadGraph graph) throws DatabaseException {
            SVGImageInfo info = new SVGImageInfo();
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            info.id = Long.toString(((Resource)this.parameter).getResourceId());
            Resource document = graph.getPossibleObject((Resource)this.parameter, DIA.Scenegraph_SVGImage_document);
            if (document != null) {
                String svg;
                Template2dResource TMPL = Template2dResource.getInstance((ReadGraph)graph);
                String path = (String)graph.getPossibleRelatedValue(document, TMPL.Profiles_VariableReference_path, (Binding)Bindings.STRING);
                if (path != null && (svg = FlagClassFactory.evaluatePath(graph, (Resource)this.parameter2, (Variable)this.parameter3, path)) != null && !svg.isEmpty()) {
                    info.svgDocument = svg;
                }
            }
            info.transform = (double[])graph.getPossibleRelatedValue((Resource)this.parameter, DIA.Scenegraph_SVGImage_transform, (Binding)Bindings.DOUBLE_ARRAY);
            return info;
        }
    }
}

