/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.rendering;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.io.Serializable;
import org.simantics.diagram.connection.rendering.ConnectionStyle;

public class BasicConnectionStyle
implements ConnectionStyle,
Serializable {
    private static final long serialVersionUID = -5799681720482456895L;
    final Color lineColor;
    final Color branchPointColor;
    final double branchPointRadius;
    final Stroke lineStroke;
    final Stroke routeLineStroke;
    final double degenerateLineLength;
    transient Line2D line = new Line2D.Double();
    transient Ellipse2D ellipse = new Ellipse2D.Double();

    public BasicConnectionStyle(Color lineColor, Color branchPointColor, double branchPointRadius, Stroke lineStroke, Stroke routeLineStroke, double degenerateLineLength) {
        this.lineColor = lineColor;
        this.branchPointColor = branchPointColor;
        this.branchPointRadius = branchPointRadius;
        this.lineStroke = lineStroke;
        this.routeLineStroke = routeLineStroke;
        this.degenerateLineLength = degenerateLineLength;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Color getBranchPointColor() {
        return this.branchPointColor;
    }

    public double getBranchPointRadius() {
        return this.branchPointRadius;
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    public Stroke getRouteLineStroke() {
        return this.routeLineStroke;
    }

    @Override
    public void drawLine(Graphics2D g, double x1, double y1, double x2, double y2, boolean isTransient) {
        if (this.lineColor != null) {
            g.setColor(this.lineColor);
        }
        if (isTransient) {
            g.setStroke(this.lineStroke);
            this.line.setLine(x1, y1, x2, y2);
            g.draw(this.line);
        } else {
            g.setStroke(this.routeLineStroke);
            this.line.setLine(x1, y1, x2, y2);
            g.draw(this.line);
        }
    }

    @Override
    public void drawPath(Graphics2D g, Path2D path, boolean isTransient) {
        if (this.lineColor != null) {
            g.setColor(this.lineColor);
        }
        if (this.lineStroke != null) {
            g.setStroke(this.lineStroke);
        }
        g.draw(path);
    }

    @Override
    public void drawBranchPoint(Graphics2D g, double x, double y) {
        g.setColor(this.branchPointColor);
        double r = this.branchPointRadius;
        double d = 2.0 * r;
        this.ellipse.setFrame(x - r, y - r, d, d);
        g.fill(this.ellipse);
    }

    @Override
    public void drawDegeneratedLine(Graphics2D g, double x, double y, boolean isHorizontal, boolean isTransient) {
        double d = this.getDegeneratedLineLength() * 0.5;
        if (isHorizontal) {
            this.line.setLine(x - d, y, x + d, y);
            g.draw(this.line);
        } else {
            this.line.setLine(x, y - d, x, y + d);
            g.draw(this.line);
        }
    }

    @Override
    public double getDegeneratedLineLength() {
        return this.degenerateLineLength;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.branchPointColor == null ? 0 : this.branchPointColor.hashCode());
        long temp = Double.doubleToLongBits(this.branchPointRadius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.degenerateLineLength);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.lineColor == null ? 0 : this.lineColor.hashCode());
        result = 31 * result + (this.lineStroke == null ? 0 : this.lineStroke.hashCode());
        result = 31 * result + (this.routeLineStroke == null ? 0 : this.routeLineStroke.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicConnectionStyle other = (BasicConnectionStyle)obj;
        if (this.branchPointColor == null ? other.branchPointColor != null : !this.branchPointColor.equals(other.branchPointColor)) {
            return false;
        }
        if (Double.doubleToLongBits(this.branchPointRadius) != Double.doubleToLongBits(other.branchPointRadius)) {
            return false;
        }
        if (Double.doubleToLongBits(this.degenerateLineLength) != Double.doubleToLongBits(other.degenerateLineLength)) {
            return false;
        }
        if (this.lineColor == null ? other.lineColor != null : !this.lineColor.equals(other.lineColor)) {
            return false;
        }
        if (this.lineStroke == null ? other.lineStroke != null : !this.lineStroke.equals(other.lineStroke)) {
            return false;
        }
        return !(this.routeLineStroke == null ? other.routeLineStroke != null : !this.routeLineStroke.equals(other.routeLineStroke));
    }
}

