/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.desktop.ui.internal;

 import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.Configuration;
import org.simantics.modeling.ModelingUtils;
import org.simantics.platform.ui.PlatformUIResource;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class NewModel extends AbstractHandler {

    public static Resource execute(WriteGraph graph) throws DatabaseException {
        PlatformUIResource PLATFORM = PlatformUIResource.getInstance(graph);
        return execute(graph, PLATFORM.Model, null);
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Job job = new DatabaseJob("Creating Model") {
            @Override
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Simantics.sync(new WriteRequest() {
                        @Override
                        public void perform(WriteGraph graph) throws DatabaseException {
                            execute(graph);
                        }
                    });
                    return Status.OK_STATUS;
                } catch (DatabaseException e) {
                    return new Status(IStatus.ERROR, Activator.PLUGIN_ID, getName() + " failed.", e);
                }
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    public static Resource execute(WriteGraph graph, Resource type, String name) throws DatabaseException {
        Resource model = ModelingUtils.createModel(graph, type, name);
        Resource conf = graph.syncRequest(new Configuration(model));

        ModelingUtils.addSCLMainToModel(graph, model, "SCLMain", "");
        ModelingUtils.createLocalLibrary(graph, model, "Library");

        Resource book = SpreadsheetGraphUtils.createBook(graph, conf, "Book1");
        SpreadsheetUtils.createSheet(graph, book, "Sheet1", new String[] { }, new int[] { 50 });
        SpreadsheetUtils.createSheet(graph, book, "Sheet2", new String[] { }, new int[] { 50 });
        SpreadsheetUtils.createSheet(graph, book, "Sheet3", new String[] { }, new int[] { 50 });

        return model;
    }

}
