/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.ui;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.debug.ListenerReport;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Write;
import org.simantics.db.service.DebugSupport;
import org.simantics.debug.ui.internal.Activator;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.utils.ui.LayoutUtils;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.views.swt.SimanticsView;

public class SessionDebuggerView
extends SimanticsView {
    public static final String VIEW_ID = "org.simantics.debug.sessionDebugger";
    private CTabFolder folder;
    private Text commandLine;
    private Browser console;
    private final LinkedList<String> terminal = new LinkedList();
    private final LinkedList<String> history = new LinkedList();
    private int historyPosition = -1;

    protected Set<String> getBrowseContexts() {
        return Collections.singleton("");
    }

    private CTabItem createItem(int index, CTabFolder folder, Control control) {
        CTabItem item = new CTabItem(folder, 0, index);
        item.setControl(control);
        return item;
    }

    protected void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        body.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1));
        this.folder = new CTabFolder(body, 0x800400);
        this.folder.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite shell = new Composite((Composite)this.folder, 0);
        shell.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1));
        this.commandLine = new Text(shell, 2048);
        this.commandLine.setLayoutData((Object)new GridData(4, 4, true, false));
        this.console = new Browser(shell, 2048);
        this.console.setLayoutData((Object)new GridData(4, 4, true, true));
        this.commandLine.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000001) {
                    if (SessionDebuggerView.this.historyPosition > 10 || SessionDebuggerView.this.historyPosition >= SessionDebuggerView.this.history.size() - 1) {
                        return;
                    }
                    Text text = SessionDebuggerView.this.commandLine;
                    LinkedList linkedList = SessionDebuggerView.this.history;
                    SessionDebuggerView sessionDebuggerView = SessionDebuggerView.this;
                    int n = sessionDebuggerView.historyPosition + 1;
                    sessionDebuggerView.historyPosition = n;
                    text.setText((String)linkedList.get(n));
                } else if (e.keyCode == 0x1000002) {
                    if (SessionDebuggerView.this.historyPosition < 0) {
                        return;
                    }
                    if (SessionDebuggerView.this.historyPosition == 0) {
                        SessionDebuggerView.this.commandLine.setText("");
                        SessionDebuggerView.this.historyPosition = -1;
                    } else {
                        Text text = SessionDebuggerView.this.commandLine;
                        LinkedList linkedList = SessionDebuggerView.this.history;
                        SessionDebuggerView sessionDebuggerView = SessionDebuggerView.this;
                        int n = sessionDebuggerView.historyPosition - 1;
                        sessionDebuggerView.historyPosition = n;
                        text.setText((String)linkedList.get(n));
                    }
                } else if (e.keyCode == 27) {
                    SessionDebuggerView.this.historyPosition = -1;
                    SessionDebuggerView.this.commandLine.setText("");
                } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    SessionDebuggerView.this.applyCommand(SessionDebuggerView.this.commandLine.getText());
                }
            }
        });
        CTabItem shellItem = this.createItem(0, this.folder, (Control)shell);
        shellItem.setText("Shell");
        this.folder.setSelection(shellItem);
    }

    private void applyCommand(final String command) {
        try {
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    DebugSupport support = (DebugSupport)graph.getService(DebugSupport.class);
                    Object data = support.query(graph, command);
                    SessionDebuggerView.this.apply(command, data);
                }
            });
        }
        catch (CancelTransactionException cancelTransactionException) {
        }
        catch (DatabaseException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.debug.ui", "Unexpected exception while applying command " + command, (Throwable)e));
        }
    }

    private void addHistory(String command, Object output) {
        if (output instanceof String) {
            this.terminal.addFirst((String)output);
        } else if (output instanceof Path) {
            try {
                Path p = (Path)output;
                long size = Files.size(p);
                if (size < 65536L) {
                    this.terminal.addFirst(new String(Files.readAllBytes(p), "UTF-8"));
                }
                this.terminal.addFirst("Wrote command '" + command + "' output to file " + p);
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.debug.ui", "Unexpected I/O exception while applying command " + command, (Throwable)e));
            }
        } else {
            throw new IllegalArgumentException("Unsupported output argument type " + output);
        }
        if (this.terminal.size() > 10) {
            this.terminal.removeLast();
        }
        this.history.addFirst(command);
        if (this.history.size() > 10) {
            this.history.removeLast();
        }
        this.historyPosition = -1;
    }

    private void apply(String command, Object data) {
        if (data instanceof String) {
            SWTUtils.asyncExec((Widget)this.commandLine, () -> {
                this.commandLine.setText("");
                this.addHistory(command, data);
                this.console.setText(this.formatTerminal());
            });
        } else if (data instanceof ListenerReport) {
            SWTUtils.asyncExec((Widget)this.commandLine, () -> {
                try {
                    this.addHistory(command, this.dumpListenerReport((ListenerReport)data));
                    this.commandLine.setText("");
                    this.console.setText(this.formatTerminal());
                }
                catch (IOException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.debug.ui", "Unexpected I/O exception while applying command " + command, (Throwable)e));
                }
            });
        }
    }

    private Path dumpListenerReport(ListenerReport data) throws IOException {
        File f = Simantics.getTempfile((String)"debug", (String)"listenerReport");
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintStream out = new PrintStream(f, "UTF-8");){
            out.print("<pre>");
            data.print(out);
            out.print("</pre>");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return f.toPath();
    }

    private String formatTerminal() {
        StringBuilder b = new StringBuilder();
        b.append("<html><head/><body>\n");
        for (String s : this.terminal) {
            b.append(s).append("<br/>\n");
        }
        b.append("</body></html>");
        return b.toString();
    }

    public void setFocus() {
        this.folder.setFocus();
    }

    protected IPropertyPage getPropertyPage() {
        return null;
    }
}

